/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class BeanBuilder
implements FactoryBean {
    private String type;
    private Map<String, String> attributes;
    private static ThreadLocal<BeanBuilder> resolvingBean = new ThreadLocal();
    private static Logger log = LoggerFactory.getLogger(BeanBuilder.class);
    private Integer dampeningTimeout = null;

    public Object getObject() {
        try {
            if (resolvingBean.get() == this) {
                log.warn("Circular Reference detected in bean creation ( " + this.type + " : " + this.attributes + "). Very likely a published pentaho bean is resolving itself. Ensure that the published attributes do not match that of the Pentaho bean query. The system will attempt to find the next highest available bean, but at a performance penilty");
                Class<?> cls = this.getClass().getClassLoader().loadClass(this.type.trim());
                resolvingBean.set(this);
                List objectReferences = PentahoSystem.getObjectFactory().getObjectReferences(cls, PentahoSessionHolder.getSession(), this.attributes);
                resolvingBean.set(null);
                if (objectReferences.size() > 1) {
                    return ((IPentahoObjectReference)objectReferences.get(1)).getObject();
                }
                throw new IllegalStateException("Fatal Circular reference in Pentaho Bean ( " + this.type + " : " + this.attributes + ")");
            }
            final Class<?> cls = this.getClass().getClassLoader().loadClass(this.type.trim());
            resolvingBean.set(this);
            Object val = null;
            IPentahoObjectReference objectReference = PentahoSystem.getObjectFactory().getObjectReference(cls, PentahoSessionHolder.getSession(), this.attributes);
            if (objectReference != null) {
                val = objectReference.getObject();
            }
            resolvingBean.set(null);
            if (val == null) {
                log.debug("No object was found to satisfy pen:bean request [" + this.type + " : " + this.attributes + "]");
                final int f_dampeningTimeout = this.getDampeningTimeout();
                if (cls.isInterface() && this.dampeningTimeout > -1) {
                    log.debug("Request bean which wasn't found is interface-based. Instantiating a Proxy dampener");
                    val = Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, new InvocationHandler(){
                        String lock = "lock_" + this.getClass().getName();
                        Object target;
                        Thread watcher;
                        boolean dead = false;

                        private void startWatcherThread(final int millis) {
                            this.watcher = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    for (int countdown = millis; countdown > 0; countdown -= 100) {
                                        try {
                                            IPentahoObjectReference objectReference = PentahoSystem.getObjectFactory().getObjectReference(cls, PentahoSessionHolder.getSession(), BeanBuilder.this.attributes);
                                            if (objectReference != null) {
                                                target = objectReference.getObject();
                                            }
                                        }
                                        catch (ObjectFactoryException e) {
                                            log.debug("Error fetching from PentahoSystem", (Throwable)e);
                                        }
                                        if (target == null) continue;
                                        String string = lock;
                                        synchronized (string) {
                                            lock.notifyAll();
                                        }
                                        return;
                                    }
                                    dead = true;
                                }
                            });
                            this.watcher.start();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            if (this.target == null && f_dampeningTimeout > 0) {
                                String string = this.lock;
                                synchronized (string) {
                                    if (this.watcher == null && !this.dead) {
                                        this.startWatcherThread(f_dampeningTimeout);
                                        this.lock.wait(f_dampeningTimeout);
                                    }
                                }
                            }
                            if (this.target == null) {
                                if (BeanBuilder.this.attributes.isEmpty() || BeanBuilder.this.attributes.size() == 1 && BeanBuilder.this.attributes.containsKey("id")) {
                                    this.target = BeanBuilder.this.getFallbackBySimpleName(cls, BeanBuilder.this.attributes);
                                }
                                if (this.target == null) {
                                    throw new IllegalStateException("Target of Bean was never resolved: " + cls.getName());
                                }
                            }
                            return method.invoke(this.target, args);
                        }
                    });
                } else if (!cls.isInterface() && (this.attributes.isEmpty() || this.attributes.size() == 1 && this.attributes.containsKey("id"))) {
                    val = this.getFallbackBySimpleName(cls, this.attributes);
                }
            }
            return val;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ObjectFactoryException e) {
            throw new RuntimeException(e);
        }
    }

    private int getDampeningTimeout() {
        if (this.dampeningTimeout == null) {
            String property;
            this.dampeningTimeout = 0;
            ISystemConfig iSystemConfig = PentahoSystem.get(ISystemConfig.class);
            if (iSystemConfig != null && (property = iSystemConfig.getProperty("system.dampening-timeout")) != null) {
                this.dampeningTimeout = Integer.valueOf(property);
            }
        }
        return this.dampeningTimeout;
    }

    private Object getFallbackBySimpleName(Class clazz, Map<String, String> attributes) {
        Object lastChanceObject = attributes != null && attributes.containsKey("id") ? PentahoSystem.get(clazz, attributes.get("id"), PentahoSessionHolder.getSession()) : PentahoSystem.get(clazz, PentahoSessionHolder.getSession());
        if (lastChanceObject != null) {
            log.warn("Target of <pen:bean class=\"" + clazz.getName() + "\"> was found using deprecated bean ID == class.getSimpleName() fallback. The target bean with the id \"" + clazz.getSimpleName() + "\" should be published directly with <pen:publish>");
        }
        return lastChanceObject;
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }
}

