/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.ui.RectangleEdge;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.uifoundation.chart.ChartDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.messages.Messages;

public class XYZSeriesCollectionChartDefinition
extends DefaultXYZDataset
implements ChartDefinition {
    private static final long serialVersionUID = -1656592010807615066L;
    private IPentahoSession session;
    private int chartType = -1;
    private static final String STACKED_NODE_NAME = "is-stacked";
    private static final String ORIENTATION_NODE_NAME = "orientation";
    private static final String DOMAIN_TITLE_NODE_NAME = "domain-title";
    private static final String DOMAIN_TITLE_FONT_NODE_NAME = "domain-title-font";
    private static final String DOMAIN_TICK_FONT_NODE_NAME = "domain-tick-font";
    private static final String DOMAIN_TICK_FORMAT_NODE_NAME = "domain-tick-format";
    private static final String DOMAIN_MINIMUM_NODE_NAME = "domain-minimum";
    private static final String DOMAIN_MAXIMUM_NODE_NAME = "domain-maximum";
    private static final String RANGE_TITLE_NODE_NAME = "range-title";
    private static final String RANGE_TITLE_FONT_NODE_NAME = "range-title-font";
    private static final String RANGE_MINIMUM_NODE_NAME = "range-minimum";
    private static final String RANGE_MAXIMUM_NODE_NAME = "range-maximum";
    private static final String RANGE_TICK_FORMAT_NODE_NAME = "range-tick-format";
    private static final String RANGE_TICK_FONT_NODE_NAME = "range-tick-font";
    private static final String DOMAIN_VERTICAL_TICK_LABELS_NODE_NAME = "domain-vertical-tick-labels";
    private static final String DOMAIN_INCLUDES_ZERO_NODE_NAME = "domain-includes-zero";
    private static final String RANGE_INCLUDES_ZERO_NODE_NAME = "range-includes-zero";
    private static final String DOMAIN_STICKY_ZERO_NODE_NAME = "domain-sticky-zero";
    private static final String RANGE_STICKY_ZERO_NODE_NAME = "range-sticky-zero";
    private static final String CHART_BORDER_PAINT_NODE_NAME = "border-paint";
    private static final String MAX_BUBBLE_SIZE_NODE_NAME = "max-bubble-size";
    private static final String BUBBLE_LABEL_CONTENT_NODE_NAME = "bubble-label-content";
    private static final String BUBBLE_LABEL_X_FORMAT_NODE_NAME = "bubble-label-x-format";
    private static final String BUBBLE_LABEL_Y_FORMAT_NODE_NAME = "bubble-label-y-format";
    private static final String BUBBLE_LABEL_Z_FORMAT_NODE_NAME = "bubble-label-z-format";
    private String noDataMessage = null;
    private String title = "";
    private RectangleEdge titlePosition = RectangleEdge.TOP;
    private Font titleFont = TextTitle.DEFAULT_FONT;
    private final List subTitles = new ArrayList();
    private Paint chartBackgroundPaint = Color.WHITE;
    private Image chartBackgroundImage = null;
    private boolean borderVisible = false;
    private Paint borderPaint = Color.BLACK;
    private int width = 200;
    private int height = 200;
    private int dotWidth = 5;
    private int dotHeight = 5;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private Paint plotBackgroundPaint = Color.WHITE;
    private Image plotBackgroundImage = null;
    private boolean legendIncluded = true;
    private boolean threeD = false;
    private boolean stacked = false;
    private boolean domainVerticalTickLabels = false;
    private boolean domainIncludesZero = true;
    private boolean domainStickyZero = true;
    private Paint[] paintSequence = null;
    private String domainTitle = null;
    private Font domainTitleFont = TextTitle.DEFAULT_FONT;
    private Font domainTickFont = null;
    private NumberFormat domainTickFormat = null;
    private double domainMinimum = 0.0;
    private double domainMaximum = 1.0;
    private boolean rangeIncludesZero = true;
    private boolean rangeStickyZero = true;
    private String rangeTitle = null;
    private Font rangeTitleFont = TextTitle.DEFAULT_FONT;
    private Font rangeTickFont = null;
    private NumberFormat rangeTickFormat = null;
    private double rangeMinimum = 0.0;
    private double rangeMaximum = 1.0;
    private double maxZValue = 0.0;
    private double maxBubbleSize = 0.0;
    private String bubbleLabelContent = "{0}: ({1}, {2}, {3})";
    private NumberFormat xFormat = NumberFormat.getNumberInstance();
    private NumberFormat yFormat = NumberFormat.getNumberInstance();
    private NumberFormat zFormat = NumberFormat.getNumberInstance();
    private Font legendFont = null;
    private boolean legendBorderVisible = true;
    private RectangleEdge legendPosition = RectangleEdge.BOTTOM;
    private Float backgroundAlpha;
    private Float foregroundAlpha;

    public XYZSeriesCollectionChartDefinition(IPentahoSession session) {
        this.session = session;
    }

    public XYZSeriesCollectionChartDefinition(int chartType, IPentahoResultSet data, boolean byRow, IPentahoSession session) {
        this(session);
        this.chartType = chartType;
        if (byRow) {
            this.setDataByRow(data);
        } else {
            this.setDataByColumn(data);
        }
    }

    public XYZSeriesCollectionChartDefinition(IPentahoResultSet data, boolean byRow, Node chartAttributes, IPentahoSession session) {
        this(-1, data, byRow, session);
        this.setChartAttributes(chartAttributes);
    }

    public static Log getLogger() {
        return LogFactory.getLog(XYZSeriesCollectionChartDefinition.class);
    }

    private void setChartAttributes(Node chartAttributes) {
        List subtitles;
        if (chartAttributes == null) {
            return;
        }
        this.setChartType(chartAttributes.selectSingleNode("chart-type"));
        this.setChartBackground(chartAttributes.selectSingleNode("chart-background"));
        this.setPlotBackground(chartAttributes.selectSingleNode("plot-background"));
        this.setOrientation(chartAttributes.selectSingleNode(ORIENTATION_NODE_NAME));
        this.setLegendIncluded(chartAttributes.selectSingleNode("include-legend"));
        this.setLegendPosition(chartAttributes.selectSingleNode("legend-position"));
        this.setTitle(chartAttributes.selectSingleNode("title"));
        Node backgroundAlphaNode = chartAttributes.selectSingleNode("background-alpha");
        Node foregroundAlphaNode = chartAttributes.selectSingleNode("foreground-alpha");
        if (backgroundAlphaNode != null) {
            this.setBackgroundAlpha(chartAttributes.selectSingleNode("background-alpha"));
        }
        if (foregroundAlphaNode != null) {
            this.setForegroundAlpha(chartAttributes.selectSingleNode("foreground-alpha"));
        }
        if ((subtitles = chartAttributes.selectNodes("subtitle")) == null || subtitles.isEmpty()) {
            Node subTitlesNode = chartAttributes.selectSingleNode("subtitles");
            if (subTitlesNode != null) {
                subtitles = subTitlesNode.selectNodes("subtitle");
            }
        } else {
            XYZSeriesCollectionChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", "subtitle", "subtitles"));
            XYZSeriesCollectionChartDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "subtitle"));
        }
        if (subtitles != null) {
            this.addSubTitles(subtitles);
        }
        this.setPaintSequence(chartAttributes.selectSingleNode("color-palette"));
        this.setStacked(chartAttributes.selectSingleNode(STACKED_NODE_NAME));
        this.setThreeD(chartAttributes.selectSingleNode("is-3D"));
        this.setWidth(chartAttributes.selectSingleNode("width"));
        this.setHeight(chartAttributes.selectSingleNode("height"));
        this.setDotWidth(chartAttributes.selectSingleNode("dot-width"));
        this.setDotHeight(chartAttributes.selectSingleNode("dot-height"));
        this.setDomainVerticalTickLabels(chartAttributes.selectSingleNode(DOMAIN_VERTICAL_TICK_LABELS_NODE_NAME));
        this.setBorderVisible(chartAttributes.selectSingleNode("border-visible"));
        this.setBorderPaint(JFreeChartEngine.getPaint(chartAttributes.selectSingleNode(CHART_BORDER_PAINT_NODE_NAME)));
        this.setTitlePosition(chartAttributes.selectSingleNode("title-position"));
        this.setTitleFont(chartAttributes.selectSingleNode("title-font"));
        this.setDomainTitle(chartAttributes.selectSingleNode(DOMAIN_TITLE_NODE_NAME));
        this.setDomainTitleFont(chartAttributes.selectSingleNode(DOMAIN_TITLE_FONT_NODE_NAME));
        this.setDomainTickFont(chartAttributes.selectSingleNode(DOMAIN_TICK_FONT_NODE_NAME));
        this.setDomainTickFormat(chartAttributes.selectSingleNode(DOMAIN_TICK_FORMAT_NODE_NAME));
        this.setRangeIncludesZero(chartAttributes.selectSingleNode(RANGE_INCLUDES_ZERO_NODE_NAME));
        this.setRangeTitle(chartAttributes.selectSingleNode(RANGE_TITLE_NODE_NAME));
        this.setRangeTitleFont(chartAttributes.selectSingleNode(RANGE_TITLE_FONT_NODE_NAME));
        this.setRangeTickFont(chartAttributes.selectSingleNode(RANGE_TICK_FONT_NODE_NAME));
        this.setRangeTickFormat(chartAttributes.selectSingleNode(RANGE_TICK_FORMAT_NODE_NAME));
        this.setDomainMinimum(chartAttributes.selectSingleNode(DOMAIN_MINIMUM_NODE_NAME));
        this.setDomainMaximum(chartAttributes.selectSingleNode(DOMAIN_MAXIMUM_NODE_NAME));
        this.setRangeMinimum(chartAttributes.selectSingleNode(RANGE_MINIMUM_NODE_NAME));
        this.setRangeMaximum(chartAttributes.selectSingleNode(RANGE_MAXIMUM_NODE_NAME));
        this.setDomainIncludesZero(chartAttributes.selectSingleNode(DOMAIN_INCLUDES_ZERO_NODE_NAME));
        this.setDomainStickyZero(chartAttributes.selectSingleNode(DOMAIN_STICKY_ZERO_NODE_NAME));
        this.setRangeIncludesZero(chartAttributes.selectSingleNode(RANGE_INCLUDES_ZERO_NODE_NAME));
        this.setRangeStickyZero(chartAttributes.selectSingleNode(RANGE_STICKY_ZERO_NODE_NAME));
        this.setMaxBubbleSize(chartAttributes.selectSingleNode(MAX_BUBBLE_SIZE_NODE_NAME));
        this.setBubbleLabelContent(chartAttributes.selectSingleNode(BUBBLE_LABEL_CONTENT_NODE_NAME));
        this.setXFormat(chartAttributes.selectSingleNode(BUBBLE_LABEL_X_FORMAT_NODE_NAME));
        this.setYFormat(chartAttributes.selectSingleNode(BUBBLE_LABEL_Y_FORMAT_NODE_NAME));
        this.setZFormat(chartAttributes.selectSingleNode(BUBBLE_LABEL_Z_FORMAT_NODE_NAME));
        this.setLegendFont(chartAttributes.selectSingleNode("legend-font"));
        this.setLegendBorderVisible(chartAttributes.selectSingleNode("legend-border-visible"));
    }

    private void setDataByColumn(IPentahoResultSet data) {
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        String seriesName = "";
        Object[] rowData = data.next();
        while (rowData != null) {
            double[][] series = new double[3][1];
            if (rowData.length >= 4 && rowData[1] instanceof Number && rowData[2] instanceof Number && rowData[3] instanceof Number) {
                seriesName = rowData[0].toString();
                double zValue = ((Number)rowData[3]).doubleValue();
                if (zValue > this.maxZValue) {
                    this.maxZValue = zValue;
                }
                series[0][0] = ((Number)rowData[1]).doubleValue();
                series[1][0] = ((Number)rowData[2]).doubleValue();
                series[2][0] = zValue;
                this.addSeries((Comparable)((Object)seriesName), series);
            }
            rowData = data.next();
        }
        if (data.getRowCount() > 0 && this.getSeriesCount() <= 0) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT");
        }
    }

    private void setDataByRow(IPentahoResultSet data) {
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        Object[] rowData = data.next();
        while (rowData != null) {
            for (int column = 0; column < rowData.length - 1; column += 4) {
                String seriesName = (String)rowData[column];
                double[][] series = new double[3][1];
                double zValue = ((Number)rowData[3]).doubleValue();
                if (zValue > this.maxZValue) {
                    this.maxZValue = zValue;
                }
                series[0][0] = ((Number)rowData[column + 1]).intValue();
                series[1][0] = ((Number)rowData[column + 2]).intValue();
                series[2][0] = zValue;
                this.addSeries((Comparable)((Object)seriesName), series);
            }
            rowData = data.next();
        }
        if (data.getRowCount() > 0 && this.getSeriesCount() <= 0) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_INCORRECT_DATA_FORMAT");
        }
    }

    public void setChartBackgroundPaint(Paint chartBackgroundPaint) {
        if (chartBackgroundPaint != null) {
            this.chartBackgroundPaint = chartBackgroundPaint;
        }
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setTitleFont(font);
        }
    }

    @Override
    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(Node chartTypeNode) {
        if (chartTypeNode != null) {
            String typeStr = chartTypeNode.getText();
            this.setChartType(JFreeChartEngine.getChartType(typeStr));
        }
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    @Override
    public boolean isThreeD() {
        return this.threeD;
    }

    public void setThreeD(Node threeDNode) {
        if (threeDNode != null) {
            String boolStr = threeDNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setThreeD(booleanValue);
        }
    }

    public void setThreeD(boolean threeD) {
        this.threeD = threeD;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(Node stackedNode) {
        if (stackedNode != null) {
            String boolStr = stackedNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setStacked(booleanValue);
        }
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public boolean isDomainVerticalTickLabels() {
        return this.domainVerticalTickLabels;
    }

    public void setDomainVerticalTickLabels(Node domainVerticalTickLabelsNode) {
        if (domainVerticalTickLabelsNode != null) {
            String boolStr = domainVerticalTickLabelsNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDomainVerticalTickLabels(booleanValue);
        }
    }

    public void setDomainVerticalTickLabels(boolean domainVerticalTickLabels) {
        this.domainVerticalTickLabels = domainVerticalTickLabels;
    }

    public boolean isDomainIncludesZero() {
        return this.domainIncludesZero;
    }

    public void setDomainIncludesZero(Node domainIncludesZeroNode) {
        if (domainIncludesZeroNode != null) {
            String boolStr = domainIncludesZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDomainIncludesZero(booleanValue);
        }
    }

    public void setDomainIncludesZero(boolean domainIncludesZero) {
        this.domainIncludesZero = domainIncludesZero;
    }

    public boolean isDomainStickyZero() {
        return this.domainStickyZero;
    }

    public void setDomainStickyZero(Node domainStickyZeroNode) {
        if (domainStickyZeroNode != null) {
            String boolStr = domainStickyZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setDomainStickyZero(booleanValue);
        }
    }

    public void setRangeStickyZero(boolean rangeStickyZero) {
        this.rangeStickyZero = rangeStickyZero;
    }

    public boolean isRangeStickyZero() {
        return this.rangeStickyZero;
    }

    public void setRangeStickyZero(Node rangeStickyZeroNode) {
        if (rangeStickyZeroNode != null) {
            String boolStr = rangeStickyZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setRangeStickyZero(booleanValue);
        }
    }

    public void setDomainStickyZero(boolean domainStickyZero) {
        this.domainStickyZero = domainStickyZero;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(Node heightNode) {
        if (heightNode != null) {
            this.setHeight(Integer.parseInt(heightNode.getText()));
        }
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(Node widthNode) {
        if (widthNode != null) {
            this.setWidth(Integer.parseInt(widthNode.getText()));
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getDotHeight() {
        return this.dotHeight;
    }

    public void setDotHeight(Node heightNode) {
        if (heightNode != null) {
            this.setDotHeight(Integer.parseInt(heightNode.getText()));
        }
    }

    public void setDotHeight(int height) {
        this.dotHeight = height;
    }

    public int getDotWidth() {
        return this.dotWidth;
    }

    public void setDotWidth(Node widthNode) {
        if (widthNode != null) {
            this.setDotWidth(Integer.parseInt(widthNode.getText()));
        }
    }

    public void setDotWidth(int width) {
        this.dotWidth = width;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(Node chartTitleNode) {
        if (chartTitleNode != null) {
            this.setTitle(chartTitleNode.getText());
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Paint[] getPaintSequence() {
        return this.paintSequence;
    }

    public void setPaintSequence(Node paletteNode) {
        if (paletteNode != null) {
            List colorNodes = paletteNode.selectNodes("color");
            Paint[] paints = new Paint[colorNodes.size()];
            for (int i = 0; i < colorNodes.size(); ++i) {
                paints[i] = JFreeChartEngine.getPaint((Node)colorNodes.get(i));
            }
            this.setPaintSequence(paints);
        }
    }

    public void setPaintSequence(Paint[] paintSequence) {
        this.paintSequence = paintSequence;
    }

    @Override
    public List getSubtitles() {
        return this.subTitles;
    }

    public void addSubTitles(List subTitleNodes) {
        if (subTitleNodes != null) {
            Iterator iter = subTitleNodes.iterator();
            while (iter.hasNext()) {
                this.addSubTitle(((Node)iter.next()).getText());
            }
        }
    }

    public void addSubTitle(String subTitle) {
        this.subTitles.add(subTitle);
    }

    @Override
    public Image getChartBackgroundImage() {
        return this.chartBackgroundImage;
    }

    public void setChartBackgroundImage(Node chartBackgroundImageNode) {
        this.setChartBackgroundImage(JFreeChartEngine.getImage(chartBackgroundImageNode, this.getSession()));
    }

    public void setChartBackgroundImage(Image chartBackgroundImage) {
        this.chartBackgroundImage = chartBackgroundImage;
    }

    @Override
    public boolean isLegendIncluded() {
        return this.legendIncluded;
    }

    public void setLegendIncluded(Node legendNode) {
        if (legendNode != null) {
            String boolStr = legendNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setLegendIncluded(booleanValue);
        }
    }

    public void setLegendIncluded(boolean legendIncluded) {
        this.legendIncluded = legendIncluded;
    }

    public void setPlotBackgroundPaint(Paint plotBackgroundPaint) {
        if (plotBackgroundPaint != null) {
            this.plotBackgroundPaint = plotBackgroundPaint;
        }
    }

    @Override
    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    @Override
    public Image getPlotBackgroundImage() {
        return this.plotBackgroundImage;
    }

    public void setPlotBackgroundImage(Node plotBackgroundImageNode) {
        this.setPlotBackgroundImage(JFreeChartEngine.getImage(plotBackgroundImageNode, this.getSession()));
    }

    public void setPlotBackgroundImage(Image plotBackgroundImage) {
        this.plotBackgroundImage = plotBackgroundImage;
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Node orientationNode) {
        if (orientationNode != null) {
            String orientationStr = orientationNode.getText();
            if ("Vertical".equalsIgnoreCase(orientationStr)) {
                this.setOrientation(PlotOrientation.VERTICAL);
            } else if ("Horizontal".equalsIgnoreCase(orientationStr)) {
                this.setOrientation(PlotOrientation.HORIZONTAL);
            }
        }
    }

    public void setOrientation(PlotOrientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public void setBorderVisible(Node borderVisibleNode) {
        if (borderVisibleNode != null) {
            String boolStr = borderVisibleNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setBorderVisible(booleanValue);
        }
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
    }

    @Override
    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.borderPaint = borderPaint;
    }

    private RectangleEdge getPosition(Node positionNode) {
        if (positionNode != null) {
            String positionStr = positionNode.getText();
            if ("top".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.TOP;
            }
            if ("left".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.LEFT;
            }
            if ("bottom".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.BOTTOM;
            }
            if ("right".equalsIgnoreCase(positionStr)) {
                return RectangleEdge.RIGHT;
            }
        }
        return null;
    }

    public void setTitlePosition(Node titlePositionNode) {
        RectangleEdge position = this.getPosition(titlePositionNode);
        if (position != null) {
            this.setTitlePosition(position);
        }
    }

    @Override
    public RectangleEdge getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(RectangleEdge titlePosition) {
        this.titlePosition = titlePosition;
    }

    public void setLegendPosition(Node legendPositionNode) {
        RectangleEdge position = this.getPosition(legendPositionNode);
        if (position != null) {
            this.setLegendPosition(position);
        }
    }

    @Override
    public RectangleEdge getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(RectangleEdge legendPosition) {
        this.legendPosition = legendPosition;
    }

    public void setChartBackground(Node chartBackgroundNode) {
        Node backgroundTypeNode;
        if (chartBackgroundNode != null && (backgroundTypeNode = chartBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getPaint(chartBackgroundNode));
                this.setChartBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundImage(chartBackgroundNode);
                this.setChartBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getTexturePaint(chartBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setChartBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setChartBackgroundPaint(JFreeChartEngine.getGradientPaint(chartBackgroundNode, this.getWidth(), this.getHeight()));
                this.setChartBackgroundImage((Image)null);
            }
        }
    }

    public void setPlotBackground(Node plotBackgroundNode) {
        Node backgroundTypeNode;
        if (plotBackgroundNode != null && (backgroundTypeNode = plotBackgroundNode.selectSingleNode("@type")) != null) {
            String backgroundTypeStr = backgroundTypeNode.getText();
            if ("color".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getPaint(plotBackgroundNode));
                this.setPlotBackgroundImage((Image)null);
            } else if ("image".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundImage(plotBackgroundNode);
                this.setPlotBackgroundPaint(null);
            } else if ("texture".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getTexturePaint(plotBackgroundNode, this.getWidth(), this.getHeight(), this.getSession()));
                this.setPlotBackgroundImage((Image)null);
            } else if ("gradient".equalsIgnoreCase(backgroundTypeStr)) {
                this.setPlotBackgroundPaint(JFreeChartEngine.getGradientPaint(plotBackgroundNode, this.getWidth(), this.getHeight()));
                this.setPlotBackgroundImage((Image)null);
            }
        }
    }

    public void setDomainTitle(Node titleNode) {
        if (titleNode != null) {
            this.setDomainTitle(titleNode.getText());
        }
    }

    public String getDomainTitle() {
        return this.domainTitle;
    }

    public void setDomainTitle(String domainTitle) {
        this.domainTitle = domainTitle;
    }

    public boolean isRangeIncludesZero() {
        return this.rangeIncludesZero;
    }

    public void setRangeIncludesZero(Node rangeIncludesZeroNode) {
        if (rangeIncludesZeroNode != null) {
            String boolStr = rangeIncludesZeroNode.getText();
            Boolean booleanValue = new Boolean(boolStr);
            this.setRangeIncludesZero(booleanValue);
        }
    }

    public void setRangeIncludesZero(boolean rangeIncludesZero) {
        this.rangeIncludesZero = rangeIncludesZero;
    }

    public void setRangeTitle(Node titleNode) {
        if (titleNode != null) {
            this.setRangeTitle(titleNode.getText());
        }
    }

    public String getRangeTitle() {
        return this.rangeTitle;
    }

    public void setRangeTitle(String rangeTitle) {
        this.rangeTitle = rangeTitle;
    }

    public void setDomainTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setDomainTitleFont(font);
        }
    }

    public Font getDomainTitleFont() {
        return this.domainTitleFont;
    }

    public void setDomainTitleFont(Font domainTitleFont) {
        this.domainTitleFont = domainTitleFont;
    }

    public Font getDomainTickFont() {
        return this.domainTickFont;
    }

    public void setDomainTickFont(Font domainTickFont) {
        this.domainTickFont = domainTickFont;
    }

    public void setDomainTickFont(Node rangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(rangeTickFontNode);
        if (font != null) {
            this.setDomainTickFont(font);
        }
    }

    public void setRangeTitleFont(Node titleFontNode) {
        Font font = JFreeChartEngine.getFont(titleFontNode);
        if (font != null) {
            this.setRangeTitleFont(font);
        }
    }

    public Font getRangeTitleFont() {
        return this.rangeTitleFont;
    }

    public void setRangeTitleFont(Font rangeTitleFont) {
        this.rangeTitleFont = rangeTitleFont;
    }

    public NumberFormat getRangeTickFormat() {
        return this.rangeTickFormat;
    }

    public void setRangeTickFormat(NumberFormat rangeTickFormat) {
        this.rangeTickFormat = rangeTickFormat;
    }

    public void setRangeTickFormat(Node tickFormatFontNode) {
        DecimalFormat format;
        if (tickFormatFontNode != null && (format = new DecimalFormat(tickFormatFontNode.getText())) != null) {
            this.setRangeTickFormat(format);
        }
    }

    public Font getRangeTickFont() {
        return this.rangeTickFont;
    }

    public void setRangeTickFont(Font rangeTickFont) {
        this.rangeTickFont = rangeTickFont;
    }

    public void setRangeTickFont(Node rangeTickFontNode) {
        Font font = JFreeChartEngine.getFont(rangeTickFontNode);
        if (font != null) {
            this.setRangeTickFont(font);
        }
    }

    public NumberFormat getDomainTickFormat() {
        return this.domainTickFormat;
    }

    public void setDomainTickFormat(NumberFormat domainTickFormat) {
        this.domainTickFormat = domainTickFormat;
    }

    public void setDomainTickFormat(Node tickFormatFontNode) {
        DecimalFormat format;
        if (tickFormatFontNode != null && (format = new DecimalFormat(tickFormatFontNode.getText())) != null) {
            this.setDomainTickFormat(format);
        }
    }

    @Override
    public boolean isDisplayLabels() {
        return false;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    public double getMaxZValue() {
        return this.maxZValue;
    }

    public void setMaxBubbleSize(Node maxBubbleSizeNode) {
        if (maxBubbleSizeNode != null) {
            String doubleStr = maxBubbleSizeNode.getText();
            Double doubleValue = new Double(doubleStr);
            this.setMaxBubbleSize(doubleValue);
        }
    }

    public double getMaxBubbleSize() {
        return this.maxBubbleSize;
    }

    public void setMaxBubbleSize(double maxBubbleSize) {
        this.maxBubbleSize = maxBubbleSize;
    }

    public String getBubbleLabelContent() {
        return this.bubbleLabelContent;
    }

    public void setBubbleLabelContent(Node bubbleLabelContentNode) {
        if (bubbleLabelContentNode != null) {
            this.setBubbleLabelContent(bubbleLabelContentNode.getText());
        }
    }

    public void setBubbleLabelContent(String bubblelabelContent) {
        this.bubbleLabelContent = bubblelabelContent;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public void setXFormat(Node bubblelabelXFormat) {
        if (bubblelabelXFormat != null) {
            DecimalFormat xFmat = new DecimalFormat(bubblelabelXFormat.getText());
            this.setXFormat(xFmat);
        }
    }

    public void setXFormat(NumberFormat format) {
        this.xFormat = format;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public void setYFormat(Node bubblelabelYFormat) {
        if (bubblelabelYFormat != null) {
            DecimalFormat yFmat = new DecimalFormat(bubblelabelYFormat.getText());
            this.setYFormat(yFmat);
        }
    }

    public void setYFormat(NumberFormat format) {
        this.yFormat = format;
    }

    public NumberFormat getZFormat() {
        return this.zFormat;
    }

    public void setZFormat(Node bubblelabelZFormat) {
        if (bubblelabelZFormat != null) {
            DecimalFormat zFmat = new DecimalFormat(bubblelabelZFormat.getText());
            this.setZFormat(zFmat);
        }
    }

    public void setZFormat(NumberFormat format) {
        this.zFormat = format;
    }

    @Override
    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public void setLegendFont(Node legendFontNode) {
        Font font = JFreeChartEngine.getFont(legendFontNode);
        if (font != null) {
            this.setLegendFont(font);
        }
    }

    public void setLegendBorderVisible(Node legendBorderVisibleNode) {
        if (legendBorderVisibleNode != null) {
            boolean legBorderVisible = new Boolean(legendBorderVisibleNode.getText());
            this.setLegendBorderVisible(legBorderVisible);
        }
    }

    public void setLegendBorderVisible(boolean legendBorderVisible) {
        this.legendBorderVisible = legendBorderVisible;
    }

    @Override
    public boolean isLegendBorderVisible() {
        return this.legendBorderVisible;
    }

    public double getRangeMinimum() {
        return this.rangeMinimum;
    }

    public void setRangeMinimum(Node rangeMinimumNode) {
        if (rangeMinimumNode != null) {
            this.setRangeMinimum(Double.parseDouble(rangeMinimumNode.getText()));
        }
    }

    public void setRangeMinimum(double rangeMinimum) {
        this.rangeMinimum = rangeMinimum;
    }

    public double getRangeMaximum() {
        return this.rangeMaximum;
    }

    public void setRangeMaximum(Node rangeMaximumNode) {
        if (rangeMaximumNode != null) {
            this.setRangeMaximum(Double.parseDouble(rangeMaximumNode.getText()));
        }
    }

    public void setRangeMaximum(double rangeMaximum) {
        this.rangeMaximum = rangeMaximum;
    }

    public double getDomainMinimum() {
        return this.domainMinimum;
    }

    public void setDomainMinimum(Node domainMinimumNode) {
        if (domainMinimumNode != null) {
            this.setDomainMinimum(Double.parseDouble(domainMinimumNode.getText()));
        }
    }

    public void setDomainMinimum(double domainMinimum) {
        this.domainMinimum = domainMinimum;
    }

    public double getDomainMaximum() {
        return this.domainMaximum;
    }

    public void setDomainMaximum(Node domainMaximumNode) {
        if (domainMaximumNode != null) {
            this.setDomainMaximum(Double.parseDouble(domainMaximumNode.getText()));
        }
    }

    public void setDomainMaximum(double domainMaximum) {
        this.domainMaximum = domainMaximum;
    }

    @Override
    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    @Override
    public Float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(Node backgroundAlphaNode) {
        if (backgroundAlphaNode != null) {
            Float backgroundAlphaValue;
            this.backgroundAlpha = backgroundAlphaValue = new Float(backgroundAlphaNode.getText());
        }
    }

    @Override
    public Float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(Node foregroundAlphaNode) {
        if (foregroundAlphaNode != null) {
            Float foregroundAlphaValue;
            this.foregroundAlpha = foregroundAlphaValue = new Float(foregroundAlphaNode.getText());
        }
    }
}

