/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.pentaho.platform.util.client.ServiceException;

public class ClientUtil {
    public static HttpClient getClient(String userId, String password) {
        HttpClient httpClientInstance = new HttpClient();
        if (userId != null && userId.length() > 0 && password != null && password.length() > 0) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userId, password);
            httpClientInstance.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
            httpClientInstance.getParams().setAuthenticationPreemptive(true);
        }
        return httpClientInstance;
    }

    public static Document getResultDom4jDocument(HttpClient client, HttpMethod callMethod) throws ServiceException {
        try {
            int status = client.executeMethod(callMethod);
            if (status != 200) {
                throw new ServiceException("Web service call failed with code " + status);
            }
            InputStream in = callMethod.getResponseBodyAsStream();
            byte[] buffer = new byte[2048];
            int n = in.read(buffer);
            StringBuilder sb = new StringBuilder();
            while (n != -1) {
                sb.append(new String(buffer, 0, n));
                n = in.read(buffer);
            }
            String result = sb.toString();
            return DocumentHelper.parseText((String)result);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        catch (DocumentException e) {
            throw new ServiceException((Exception)((Object)e));
        }
    }
}

