/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.examples;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.check.DefaultValidator;
import ca.uhn.hl7v2.conf.parser.ProfileParser;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.PipeParser;
import java.io.IOException;

public class MessageValidationUsingConformanceProfile {
    public static void main(String[] args) throws ProfileException, IOException, HL7Exception {
        String validMessageString = "MSH|^~\\&|MedSeries|CAISI_1-2|PLS|3910|200903230934||ADT^A31^ADT_A05|75535037-1237815294895|P^T|2.4\r\nEVN|A31|200903230934\r\nPID|1||29^^CAISI_1-2^PI~\"\"||Test300^Leticia^^^^^L||19770202|M||||||||||||||||||||||";
        Message validMessage = new PipeParser().parse(validMessageString);
        ProfileParser profileParser = new ProfileParser(false);
        RuntimeProfile profile = profileParser.parseClasspath("ca/uhn/hl7v2/examples/profiles/ADT_A31.xml");
        DefaultValidator validator = new DefaultValidator();
        HL7Exception[] exceptions = validator.validate(validMessage, profile.getMessage());
        System.out.println("Found " + exceptions.length + " problems");
        for (int i = 0; i < exceptions.length; ++i) {
            HL7Exception exception = exceptions[i];
            System.out.println(" * " + ((Object)((Object)exception)).getClass().getSimpleName() + " - " + exception.getMessage());
        }
    }
}

