/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.io.ClientInvoker;
import org.apache.aries.rsa.provider.fastbin.io.ServerInvoker;
import org.apache.aries.rsa.provider.fastbin.tcp.ClientInvokerImpl;
import org.apache.aries.rsa.provider.fastbin.tcp.ServerInvokerImpl;
import org.apache.aries.rsa.provider.fastbin.util.UuidGenerator;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.apache.aries.rsa.spi.Endpoint;
import org.apache.aries.rsa.spi.IntentUnsatisfiedException;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

public class FastBinProvider
implements DistributionProvider {
    public static final String FASTBIN_CONFIG_TYPE = "aries.fastbin";
    public static final String FASTBIN_ADDRESS = "aries.fastbin.address";
    private final String uri;
    private final String exportedAddress;
    private final long timeout;
    private final DispatchQueue queue = Dispatch.createQueue();
    private final Map<String, SerializationStrategy> serializationStrategies = new ConcurrentHashMap<String, SerializationStrategy>();
    private ClientInvoker client;
    private ServerInvoker server;

    public FastBinProvider(String uri, String exportedAddress, long timeout) throws Exception {
        this.uri = uri;
        this.exportedAddress = exportedAddress;
        this.timeout = timeout;
        this.client = new ClientInvokerImpl(this.queue, timeout, this.serializationStrategies);
        this.server = new ServerInvokerImpl(uri, this.queue, this.serializationStrategies);
        this.client.start();
        this.server.start();
    }

    public void close() {
        this.client.stop();
        this.server.stop();
    }

    public ClientInvoker getClient() {
        return this.client;
    }

    public ServerInvoker getServer() {
        return this.server;
    }

    public String[] getSupportedTypes() {
        return new String[]{FASTBIN_CONFIG_TYPE};
    }

    public Endpoint exportService(final Object serviceO, BundleContext serviceContext, Map<String, Object> effectiveProperties, Class[] exportedInterfaces) {
        String endpointId = UuidGenerator.getUUID();
        effectiveProperties.put("endpoint.id", endpointId);
        URI connectUri = URI.create(this.server.getConnectAddress());
        String fastbinAddress = connectUri.getScheme() + "://" + this.exportedAddress + ":" + connectUri.getPort();
        effectiveProperties.put(FASTBIN_ADDRESS, fastbinAddress);
        effectiveProperties.put("service.imported.configs", this.getSupportedTypes());
        final EndpointDescription description = new EndpointDescription(effectiveProperties);
        this.server.registerService(description.getId(), new ServerInvoker.ServiceFactory(){

            @Override
            public Object get() {
                return serviceO;
            }

            @Override
            public void unget() {
            }
        }, serviceO.getClass().getClassLoader());
        return new Endpoint(){

            public EndpointDescription description() {
                return description;
            }

            public void close() throws IOException {
                FastBinProvider.this.server.unregisterService(description.getId());
            }
        };
    }

    public Object importEndpoint(ClassLoader cl, BundleContext consumerContext, Class[] interfaces, EndpointDescription endpoint) throws IntentUnsatisfiedException {
        String address = (String)endpoint.getProperties().get(FASTBIN_ADDRESS);
        InvocationHandler handler = this.client.getProxy(address, endpoint.getId(), cl);
        return Proxy.newProxyInstance(cl, interfaces, handler);
    }
}

