/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.log4j.Logger;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationClassLoader;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.api.ActiveHadoopConfigurationLocator;
import org.pentaho.hadoop.shim.api.Required;
import org.pentaho.hadoop.shim.api.ShimProperties;
import org.pentaho.hadoop.shim.spi.HadoopConfigurationProvider;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.hadoop.shim.spi.PentahoHadoopShim;
import org.pentaho.hadoop.shim.spi.PigShim;
import org.pentaho.hadoop.shim.spi.SnappyShim;
import org.pentaho.hadoop.shim.spi.SqoopShim;
import org.pentaho.hbase.shim.spi.HBaseShim;
import org.pentaho.oozie.shim.api.OozieClientFactory;

public class HadoopConfigurationLocator
implements HadoopConfigurationProvider {
    private static final String JAR_EXTENSION = ".jar";
    private static final String CONFIG_PROPERTIES_FILE = "config.properties";
    private static final String CONFIG_PROPERTY_IGNORE_CLASSES = "ignore.classes";
    private static final String CONFIG_PROPERTY_EXCLUDE_JARS = "exclude.jars";
    private static final String SHIM_CLASSPATH_IGNORE = "classpath.ignore";
    private static final String CONFIG_PROPERTY_CLASSPATH = "classpath";
    private static final String CONFIG_PROPERTY_LIBRARY_PATH = "library.path";
    private static final String CONFIG_PROPERTY_NAME = "name";
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static final Class<?> PKG = HadoopConfigurationLocator.class;
    private Logger logger = Logger.getLogger(this.getClass());
    private static final Class<? extends PentahoHadoopShim>[] SHIM_TYPES = new Class[]{HadoopShim.class, HBaseShim.class, PigShim.class, SnappyShim.class, SqoopShim.class, OozieClientFactory.class};
    private static final PentahoHadoopShim[] EMPTY_SHIM_ARRAY = new PentahoHadoopShim[0];
    private Map<String, HadoopConfiguration> configurations;
    private boolean initialized;
    private ActiveHadoopConfigurationLocator activeLocator;
    private HadoopConfigurationFileSystemManager fsm;
    private DefaultFileSystemManager defaultFsm;

    public void init(FileObject baseDir, ActiveHadoopConfigurationLocator activeLocator, DefaultFileSystemManager fsm) throws ConfigurationException {
        if (baseDir == null) {
            throw new NullPointerException(FileObject.class.getSimpleName() + " is required");
        }
        if (activeLocator == null) {
            throw new NullPointerException(ActiveHadoopConfigurationLocator.class.getSimpleName() + " is required");
        }
        if (fsm == null) {
            throw new NullPointerException(DefaultFileSystemManager.class.getSimpleName() + " is required");
        }
        this.defaultFsm = fsm;
        this.fsm = new HadoopConfigurationFileSystemManager(this, fsm);
        this.findHadoopConfigurations(baseDir, activeLocator);
        this.activeLocator = activeLocator;
        this.initialized = true;
    }

    private void findHadoopConfigurations(FileObject baseDir, ActiveHadoopConfigurationLocator activeLocator) throws ConfigurationException {
        this.configurations = new HashMap<String, HadoopConfiguration>();
        try {
            if (!baseDir.exists()) {
                throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.HadoopConfigurationDirectoryDoesNotExist", (Object[])new Object[]{baseDir.getURL()}));
            }
            for (FileObject f : baseDir.findFiles(new FileSelector(){

                public boolean includeFile(FileSelectInfo info) throws Exception {
                    return info.getDepth() == 1 && FileType.FOLDER.equals((Object)info.getFile().getType());
                }

                public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                    return info.getDepth() == 0;
                }
            })) {
                HadoopConfiguration config;
                if (!f.getName().getBaseName().equalsIgnoreCase(activeLocator.getActiveConfigurationId()) || (config = this.loadHadoopConfiguration(f)) == null) continue;
                this.configurations.put(config.getIdentifier(), config);
            }
        }
        catch (FileSystemException ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.UnableToLoadConfigurations", (String[])new String[]{baseDir.getName().getFriendlyURI()}), ex);
        }
    }

    protected List<URL> filterJars(List<URL> urls, String excludedJarsProperty) {
        String[] excludedJars;
        if (excludedJarsProperty != null && !excludedJarsProperty.trim().isEmpty() && (excludedJars = excludedJarsProperty.split(",")) != null) {
            for (String excludedJar : excludedJars) {
                Pattern pattern = Pattern.compile(".*/" + excludedJar.toLowerCase() + "-.*\\.jar$");
                Matcher matcher = pattern.matcher("");
                ListIterator<URL> iterator = urls.listIterator();
                while (iterator.hasNext()) {
                    URL url = (URL)iterator.next();
                    if (!url.toString().toLowerCase().contains(excludedJar.toLowerCase())) continue;
                    if (excludedJar.endsWith(JAR_EXTENSION) || url.toString().toLowerCase().contains(excludedJar.toLowerCase() + JAR_EXTENSION)) {
                        iterator.remove();
                        continue;
                    }
                    if (!matcher.reset(url.toString().toLowerCase()).matches()) continue;
                    iterator.remove();
                }
            }
        }
        return urls;
    }

    private List<URL> findJarsIn(FileObject path, final int maxdepth, final Set<String> paths) throws FileSystemException {
        FileObject[] jars = path.findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo info) throws Exception {
                for (String path : paths) {
                    if (!info.getFile().getURL().toString().endsWith(path)) continue;
                    return false;
                }
                return info.getFile().getName().getBaseName().endsWith(HadoopConfigurationLocator.JAR_EXTENSION);
            }

            public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                for (String path : paths) {
                    if (!info.getFile().getURL().toString().endsWith(path)) continue;
                    return false;
                }
                return info.getDepth() <= maxdepth;
            }
        });
        ArrayList<URL> jarUrls = new ArrayList<URL>();
        for (FileObject jar : jars) {
            jarUrls.add(jar.getURL());
        }
        return jarUrls;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)"Error.LocatorNotInitialized", (String[])new String[0]));
        }
    }

    protected <T> T locateServiceImpl(ClassLoader cl, Class<T> service) {
        ServiceLoader<T> loader = ServiceLoader.load(service, cl);
        Iterator<T> iter = loader.iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    protected ClassLoader createConfigurationLoader(FileObject root, ClassLoader parent, List<URL> classpathUrls, ShimProperties configurationProperties, String ... ignoredClasses) throws ConfigurationException {
        try {
            if (root == null || !FileType.FOLDER.equals((Object)root.getType())) {
                throw new IllegalArgumentException("root must be a folder: " + root);
            }
            List<URL> jars = this.findJarsIn(root, 3, configurationProperties.getConfigSet(SHIM_CLASSPATH_IGNORE));
            jars.add(0, new URL(root.getURL().toExternalForm() + "/"));
            if (classpathUrls != null) {
                jars.addAll(0, classpathUrls);
            }
            jars = this.filterJars(jars, configurationProperties.getProperty(CONFIG_PROPERTY_EXCLUDE_JARS));
            return new HadoopConfigurationClassLoader(jars.toArray(EMPTY_URL_ARRAY), parent, ignoredClasses);
        }
        catch (Exception ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.CreatingClassLoader", (String[])new String[0]), ex);
        }
    }

    protected List<URL> parseURLs(FileObject root, String urlString) {
        if (urlString == null || urlString.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] paths = urlString.split(",");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : paths) {
            try {
                FileObject file = root.resolveFile(path.trim());
                if (!file.exists()) {
                    file = this.defaultFsm.resolveFile(path.trim());
                }
                if (FileType.FOLDER.equals((Object)file.getType())) {
                    urls.add(new URL(file.getURL().toExternalForm() + "/"));
                    urls.addAll(this.findJarsIn(file, 1, new HashSet<String>()));
                    continue;
                }
                urls.add(file.getURL());
            }
            catch (Exception e) {
                this.logger.error((Object)BaseMessages.getString(PKG, (String)"Error.InvalidClasspathEntry", (String[])new String[]{path}));
            }
        }
        return urls;
    }

    protected HadoopConfiguration loadHadoopConfiguration(FileObject folder) throws ConfigurationException {
        ShimProperties configurationProperties = new ShimProperties();
        try {
            FileObject configFile = folder.getChild(CONFIG_PROPERTIES_FILE);
            if (configFile != null) {
                configurationProperties.putAll((Map<?, ?>)this.loadProperties(configFile));
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.UnableToLoadConfigurationProperties", (String[])new String[]{CONFIG_PROPERTIES_FILE}));
        }
        for (Map.Entry<String, String> entry : configurationProperties.getPrefixedProperties("java.system").entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
        try {
            List<URL> classpathElements = this.parseURLs(folder, configurationProperties.getProperty(CONFIG_PROPERTY_CLASSPATH));
            String ignoredClassesProperty = configurationProperties.getProperty(CONFIG_PROPERTY_IGNORE_CLASSES);
            String[] ignoredClasses = null;
            if (ignoredClassesProperty != null) {
                ignoredClasses = ignoredClassesProperty.split(",");
            }
            ClassLoader cl = this.createConfigurationLoader(folder, this.getClass().getClassLoader(), classpathElements, configurationProperties, ignoredClasses);
            this.verifyClasses(cl, configurationProperties.getProperty("required.classes"), configurationProperties.getProperty(CONFIG_PROPERTY_NAME));
            HadoopShim hadoopShim = null;
            ArrayList<PentahoHadoopShim> shims = new ArrayList<PentahoHadoopShim>();
            for (Class<? extends PentahoHadoopShim> shimType : SHIM_TYPES) {
                PentahoHadoopShim s = this.locateServiceImpl(cl, shimType);
                if (s == null && shimType.getAnnotation(Required.class) != null) {
                    this.logger.warn((Object)BaseMessages.getString(PKG, (String)"Error.MissingRequiredShim", (String[])new String[]{shimType.getSimpleName()}));
                    return null;
                }
                if (HadoopShim.class.isAssignableFrom(shimType)) {
                    hadoopShim = (HadoopShim)s;
                    continue;
                }
                shims.add(s);
            }
            String id = folder.getName().getBaseName();
            String name = configurationProperties.getProperty(CONFIG_PROPERTY_NAME, id);
            HadoopConfiguration config = new HadoopConfiguration(configurationProperties, folder, id, name, hadoopShim, shims.toArray(EMPTY_SHIM_ARRAY));
            this.registerNativeLibraryPaths(configurationProperties.getProperty(CONFIG_PROPERTY_LIBRARY_PATH));
            hadoopShim.onLoad(config, this.fsm);
            return config;
        }
        catch (Throwable t) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.LoadingConfiguration", (String[])new String[0]) + " " + t.toString(), t);
        }
    }

    protected void verifyClasses(ClassLoader classLoader, String requiredClasses, String shimName) throws ConfigurationException {
        if (!Const.isEmpty((String)requiredClasses)) {
            for (String className : requiredClasses.split(",")) {
                try {
                    classLoader.loadClass(className);
                }
                catch (Throwable e) {
                    throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.MissingRequiredClasses", (String[])new String[]{className, shimName}));
                }
            }
        }
    }

    protected void registerNativeLibraryPaths(String paths) {
        if (paths == null) {
            return;
        }
        for (String path : paths.split(",")) {
            boolean successful = this.registerNativeLibraryPath(path);
            if (successful) continue;
            this.logger.error((Object)BaseMessages.getString(PKG, (String)"Error.RegisteringLibraryPath", (String[])new String[]{path}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean registerNativeLibraryPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        path = path.trim();
        try {
            Field f = ClassLoader.class.getDeclaredField("usr_paths");
            boolean accessible = f.isAccessible();
            f.setAccessible(true);
            try {
                String[] paths;
                for (String p : paths = (String[])f.get(null)) {
                    if (!p.equals(path)) continue;
                    boolean bl = true;
                    return bl;
                }
                String[] newPaths = new String[paths.length + 1];
                System.arraycopy(paths, 0, newPaths, 0, paths.length);
                newPaths[paths.length] = path;
                f.set(null, newPaths);
                int n = 1;
                return n != 0;
            }
            finally {
                f.setAccessible(accessible);
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected Properties loadProperties(FileObject file) throws FileSystemException, IOException {
        Properties p = new Properties();
        p.load(file.getContent().getInputStream());
        return p;
    }

    public List<HadoopConfiguration> getConfigurations() {
        this.checkInitialized();
        return new ArrayList<HadoopConfiguration>(this.configurations.values());
    }

    @Override
    public boolean hasConfiguration(String id) {
        this.checkInitialized();
        return this.configurations.containsKey(id);
    }

    @Override
    public HadoopConfiguration getConfiguration(String id) throws ConfigurationException {
        this.checkInitialized();
        HadoopConfiguration config = this.configurations.get(id);
        if (config == null) {
            throw new ConfigurationException(BaseMessages.getString(PKG, (String)"Error.UnknownHadoopConfiguration", (String[])new String[]{id}));
        }
        return config;
    }

    @Override
    public HadoopConfiguration getActiveConfiguration() throws ConfigurationException {
        return this.getConfiguration(this.activeLocator.getActiveConfigurationId());
    }
}

