/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.ParseModes;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.functions.FileInputContentFunctionPartitioned;
import org.pentaho.di.engine.spark.impl.functions.SparkToKettleRowFunction;
import org.pentaho.di.engine.spark.spi.KettleStepFunction;
import org.pentaho.di.engine.spark.spi.SparkOperationFactory;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;

public class FileInputSparkOperation
implements SparkOperation {
    private static final long serialVersionUID = 6935963394687169493L;
    private final TransMeta transMeta;
    private final JavaSparkContext sparkContext;
    private final Operation operation;
    private final FileInputList fileInputs;
    private final String fileScheme;
    private static final String DEFAULT_FILE_SCHEME = "file";
    private final Supplier<JavaRDD<Row>> DEFAULT_FILE_ACTION = this::loadDefaultAction;
    private Map<String, Supplier<JavaRDD<Row>>> fileActionMap = ImmutableMap.of((Object)"file", this::loadLocalAction, (Object)"hdfs", this.DEFAULT_FILE_ACTION);
    private TextFileInputMeta fileMeta;

    public FileInputSparkOperation(Operation operation, Transformation transformation, StepMeta stepMeta, JavaSparkContext sparkContext, ExecutionContext executionContext) {
        this.transMeta = stepMeta.getParentTransMeta();
        this.fileMeta = (TextFileInputMeta)Util.getTypedStepMeta((StepMeta)stepMeta, TextFileInputMeta.class);
        this.operation = operation;
        this.sparkContext = sparkContext;
        this.fileInputs = this.fileMeta.getFileInputList((VariableSpace)this.transMeta);
        this.fileScheme = this.getFileScheme(this.fileInputs);
    }

    @VisibleForTesting
    FileInputSparkOperation(Operation op, StepMeta stepMeta, JavaSparkContext context, ExecutionContext executionContext, Map<String, Supplier<JavaRDD<Row>>> fileActionMap) {
        this(op, null, stepMeta, context, executionContext);
        this.fileActionMap = fileActionMap;
    }

    private String getFileScheme(FileInputList fileInputs) {
        try {
            String scheme = ((FileObject)fileInputs.getFiles().stream().findFirst().orElseThrow(() -> new RuntimeException("No files defined in input step " + this.getId()))).getURL().toURI().getScheme();
            return Optional.ofNullable(scheme).orElse(DEFAULT_FILE_SCHEME);
        }
        catch (URISyntaxException | FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    public static SparkOperationFactory factory() {
        return new SparkOperationFactory(FileInputSparkOperation::new, new Supplier[0]);
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Supplier<JavaRDD<Row>> readAction = this.fileActionMap.getOrDefault(this.fileScheme, this.DEFAULT_FILE_ACTION);
        subscriber.setOutput(CompletableFuture.supplyAsync(readAction, arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0)));
    }

    private JavaRDD<Row> loadDefaultActionCsv() {
        SparkSession sparkSession = Util.getSparkSession();
        Dataset dataset = sparkSession.read().format("org.apache.spark.csv").option("delimiter", this.fileMeta.content.separator).option("header", this.fileMeta.content.header).option("quote", this.fileMeta.content.enclosure).option("escape", this.fileMeta.content.escapeCharacter).option("charset", this.fileMeta.content.encoding == null ? Charset.defaultCharset().name() : this.fileMeta.content.encoding).option("mode", this.fileMeta.errorHandling.errorIgnored ? ParseModes.DROP_MALFORMED_MODE() : ParseModes.FAIL_FAST_MODE()).schema(Util.getReadStructType((RowMetaInterface)Util.getRowMeta((TransMeta)this.transMeta, (String)this.getId()))).csv(this.fileInputs.getFileStrings());
        HashMap<Integer, SparkToKettleRowFunction.StrToDateFunction> functionMap = new HashMap<Integer, SparkToKettleRowFunction.StrToDateFunction>();
        functionMap.put(3, new SparkToKettleRowFunction.StrToDateFunction());
        functionMap.put(9, new SparkToKettleRowFunction.StrToDateFunction());
        return dataset.toJavaRDD().map((Function)new SparkToKettleRowFunction(this.getId(), this.transMeta, functionMap));
    }

    private JavaRDD<Row> loadDefaultActionFixedWidth() {
        JavaRDD fileRdd = this.sparkContext.textFile(String.join((CharSequence)",", this.fileInputs.getFileStrings()));
        FileInputContentFunctionPartitioned contentFunctionPartitions = new FileInputContentFunctionPartitioned(this.getId(), this.transMeta);
        return fileRdd.mapPartitions((FlatMapFunction)contentFunctionPartitions);
    }

    private JavaRDD<Row> loadDefaultAction() {
        if ("CSV".equals(this.fileMeta.content.fileType)) {
            return this.loadDefaultActionCsv();
        }
        return this.loadDefaultActionFixedWidth();
    }

    private JavaRDD<Row> loadLocalAction() {
        try {
            KettleStepFunction stepFunction = new KettleStepFunction(this.fileMeta.getParentStepMeta());
            return this.sparkContext.parallelize(stepFunction.runOnDriver());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

