/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.ops;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.execution.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.execution.OperationLogger;
import org.pentaho.di.engine.spark.impl.functions.FunctionLogger;
import org.pentaho.di.engine.spark.spi.KettleStepFunction;
import org.pentaho.di.trans.step.StepMeta;

public class GenericSparkOperation
implements SparkOperation {
    private final JavaSparkContext sparkContext;
    private final Operation operation;
    private final boolean parallelSafe;
    private KettleStepFunction wrapper;
    private OperationLogger logger;

    public GenericSparkOperation(JavaSparkContext sparkContext, Operation operation, StepMeta stepMeta, boolean parallelSafe) {
        this(sparkContext, operation, parallelSafe, new KettleStepFunction(stepMeta));
    }

    public GenericSparkOperation(JavaSparkContext sparkContext, Operation operation, boolean parallelSafe, KettleStepFunction stepFunction) {
        this.sparkContext = sparkContext;
        this.operation = operation;
        this.parallelSafe = parallelSafe;
        this.wrapper = stepFunction;
    }

    public String getId() {
        return this.operation.getId();
    }

    public void apply(SparkOperation.Subscriber subscriber) {
        Optional<JavaRDD> input = subscriber.getInput().map(rdd -> !this.parallelSafe ? rdd.coalesce(1) : rdd);
        Map accumulators = subscriber.getAccumulators();
        this.logger = subscriber.getLogger();
        accumulators.values().stream().filter(acc -> !acc.isRegistered()).forEach(arg_0 -> ((SparkContext)this.sparkContext.sc()).register(arg_0));
        Optional.ofNullable(accumulators.get("trans_logging")).map(CollectionAccumulator.class::cast).map(FunctionLogger::new).ifPresent(functionLogger -> this.wrapper.setTransLogger((FunctionLogger)functionLogger));
        Optional.ofNullable(accumulators.get("op_logging")).map(CollectionAccumulator.class::cast).map(FunctionLogger::new).ifPresent(functionLogger -> this.wrapper.setOperationLogger((FunctionLogger)functionLogger));
        CompletableFuture output = input.map(rdd -> CompletableFuture.completedFuture(rdd.mapPartitions((FlatMapFunction)this.wrapper))).orElseGet(() -> {
            CompletableFuture<List> rows = CompletableFuture.supplyAsync(() -> ((KettleStepFunction)this.wrapper).runOnDriver(), arg_0 -> ((SparkOperation.Subscriber)subscriber).registerDriverAction(arg_0));
            rows.thenAccept(rowList -> subscriber.updateMetrics(metrics -> new Metrics(0L, (long)rowList.size(), metrics.getDropped(), 0L)));
            rows.exceptionally(th -> {
                OperationErrorEvent.sendEvent((JavaSparkContext)this.sparkContext, (String)this.operation.getId(), (Throwable)th);
                return null;
            });
            return rows.thenApply(arg_0 -> ((JavaSparkContext)this.sparkContext).parallelize(arg_0));
        });
        this.logger.basic("GenericSparkOperation (" + this.getId() + ") initialized successfully");
        subscriber.setOutput(output);
    }

    public Optional<Operation> getLogicalOperation() {
        return Optional.of(this.operation);
    }

    public boolean isParallelSafe() {
        return this.parallelSafe;
    }
}

