/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class ColAndCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int[] colNums;
    private int outputColumn;
    private int[] mapToChildExpression;
    private int[] andSelected;
    private boolean[] intermediateNulls;

    public ColAndCol(int[] colNums, int outputColumn) {
        this();
        this.colNums = colNums;
        this.outputColumn = outputColumn;
        this.mapToChildExpression = null;
        this.andSelected = new int[1024];
        this.intermediateNulls = new boolean[1024];
    }

    public ColAndCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        int i;
        int i2;
        int j;
        int childExpressionIndex;
        int n;
        Preconditions.checkState(this.colNums.length >= 2);
        if (this.childExpressions != null && this.mapToChildExpression == null) {
            this.mapToChildExpression = new int[this.colNums.length];
            Arrays.fill(this.mapToChildExpression, -1);
            int c = 0;
            while (c < this.childExpressions.length) {
                VectorExpression ve = this.childExpressions[c];
                int outputColumn = ve.getOutputColumn();
                int i3 = 0;
                while (true) {
                    if (i3 >= this.colNums.length) {
                        throw new RuntimeException("Vectorized child expression output not found");
                    }
                    if (this.colNums[i3] == outputColumn) break;
                    ++i3;
                }
                this.mapToChildExpression[i3] = c++;
            }
        }
        if ((n = batch.size) <= 0) {
            return;
        }
        if (this.childExpressions != null && (childExpressionIndex = this.mapToChildExpression[0]) != -1) {
            VectorExpression ve = this.childExpressions[childExpressionIndex];
            Preconditions.checkState(ve.getOutputColumn() == this.colNums[0]);
            ve.evaluate(batch);
        }
        int[] sel = batch.selected;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        boolean andRepeating = false;
        boolean andRepeatingIsNull = false;
        int andSel = 0;
        Arrays.fill(this.intermediateNulls, 0, 1024, false);
        outV.reset();
        LongColumnVector firstColVector = (LongColumnVector)batch.cols[this.colNums[0]];
        long[] firstVector = firstColVector.vector;
        if (firstColVector.isRepeating) {
            if (firstColVector.noNulls || !firstColVector.isNull[0]) {
                if (firstVector[0] == 0L) {
                    outV.isRepeating = true;
                    outputVector[0] = 0L;
                    return;
                }
            } else {
                Preconditions.checkState(firstColVector.isNull[0]);
                andRepeatingIsNull = true;
            }
            andRepeating = true;
        } else if (firstColVector.noNulls) {
            if (batch.selectedInUse) {
                for (j = 0; j != n; ++j) {
                    i2 = sel[j];
                    if (firstVector[i2] != 1L) continue;
                    this.andSelected[andSel++] = i2;
                }
            } else {
                for (i = 0; i != n; ++i) {
                    if (firstVector[i] != 1L) continue;
                    this.andSelected[andSel++] = i;
                }
            }
        } else if (batch.selectedInUse) {
            for (j = 0; j != n; ++j) {
                i2 = sel[j];
                if (firstColVector.isNull[i2]) {
                    this.intermediateNulls[i2] = true;
                    this.andSelected[andSel++] = i2;
                    continue;
                }
                if (firstVector[i2] != 1L) continue;
                this.andSelected[andSel++] = i2;
            }
        } else {
            for (i = 0; i != n; ++i) {
                if (firstColVector.isNull[i]) {
                    this.intermediateNulls[i] = true;
                    this.andSelected[andSel++] = i;
                    continue;
                }
                if (firstVector[i] != 1L) continue;
                this.andSelected[andSel++] = i;
            }
        }
        int colNum = 1;
        while (andRepeating || andSel != 0) {
            int i4;
            int childExpressionIndex2;
            if (this.childExpressions != null && (childExpressionIndex2 = this.mapToChildExpression[colNum]) != -1) {
                if (andRepeating) {
                    VectorExpression ve = this.childExpressions[childExpressionIndex2];
                    Preconditions.checkState(ve.getOutputColumn() == this.colNums[colNum]);
                    ve.evaluate(batch);
                } else {
                    boolean saveSelectedInUse = batch.selectedInUse;
                    int[] saveSelected = sel;
                    batch.selectedInUse = true;
                    batch.selected = this.andSelected;
                    VectorExpression ve = this.childExpressions[childExpressionIndex2];
                    Preconditions.checkState(ve.getOutputColumn() == this.colNums[colNum]);
                    ve.evaluate(batch);
                    batch.selectedInUse = saveSelectedInUse;
                    batch.selected = saveSelected;
                }
            }
            LongColumnVector nextColVector = (LongColumnVector)batch.cols[this.colNums[colNum]];
            long[] nextVector = nextColVector.vector;
            if (andRepeating) {
                if (nextColVector.isRepeating) {
                    if (nextColVector.noNulls || !nextColVector.isNull[0]) {
                        if (nextVector[0] == 0L) {
                            outV.isRepeating = true;
                            outputVector[0] = 0L;
                            return;
                        }
                    } else {
                        Preconditions.checkState(nextColVector.isNull[0]);
                        andRepeatingIsNull = true;
                    }
                } else if (nextColVector.noNulls) {
                    Preconditions.checkState(andSel == 0);
                    andRepeating = false;
                    if (andRepeatingIsNull) {
                        if (batch.selectedInUse) {
                            for (int j2 = 0; j2 != n; ++j2) {
                                int i5 = sel[j2];
                                if (nextVector[i5] != 1L) continue;
                                this.intermediateNulls[i5] = true;
                                this.andSelected[andSel++] = i5;
                            }
                        } else {
                            for (int i6 = 0; i6 != n; ++i6) {
                                if (nextVector[i6] != 1L) continue;
                                this.intermediateNulls[i6] = true;
                                this.andSelected[andSel++] = i6;
                            }
                        }
                        andRepeatingIsNull = false;
                    } else if (batch.selectedInUse) {
                        for (int j3 = 0; j3 != n; ++j3) {
                            int i7 = sel[j3];
                            if (nextVector[i7] != 1L) continue;
                            this.andSelected[andSel++] = i7;
                        }
                    } else {
                        for (int i8 = 0; i8 != n; ++i8) {
                            if (nextVector[i8] != 1L) continue;
                            this.andSelected[andSel++] = i8;
                        }
                    }
                } else {
                    Preconditions.checkState(andSel == 0);
                    andRepeating = false;
                    if (andRepeatingIsNull) {
                        if (batch.selectedInUse) {
                            for (int j4 = 0; j4 != n; ++j4) {
                                int i9 = sel[j4];
                                if (!nextColVector.isNull[i9] && nextVector[i9] != 1L) continue;
                                this.intermediateNulls[i9] = true;
                                this.andSelected[andSel++] = i9;
                            }
                        } else {
                            for (int i10 = 0; i10 != n; ++i10) {
                                if (!nextColVector.isNull[i10] && nextVector[i10] != 1L) continue;
                                this.intermediateNulls[i10] = true;
                                this.andSelected[andSel++] = i10;
                            }
                        }
                        andRepeatingIsNull = false;
                    } else if (batch.selectedInUse) {
                        for (int j5 = 0; j5 != n; ++j5) {
                            int i11 = sel[j5];
                            if (nextColVector.isNull[i11]) {
                                this.intermediateNulls[i11] = true;
                                this.andSelected[andSel++] = i11;
                                continue;
                            }
                            if (nextVector[i11] != 1L) continue;
                            this.andSelected[andSel++] = i11;
                        }
                    } else {
                        for (int i12 = 0; i12 != n; ++i12) {
                            if (nextColVector.isNull[i12]) {
                                this.intermediateNulls[i12] = true;
                                this.andSelected[andSel++] = i12;
                                continue;
                            }
                            if (nextVector[i12] != 1L) continue;
                            this.andSelected[andSel++] = i12;
                        }
                    }
                }
            } else if (nextColVector.isRepeating) {
                if (nextColVector.noNulls || !nextColVector.isNull[0]) {
                    if (nextVector[0] == 0L) {
                        outV.isRepeating = true;
                        outputVector[0] = 0L;
                        return;
                    }
                } else {
                    Preconditions.checkState(nextColVector.isNull[0]);
                    for (int j6 = 0; j6 < andSel; ++j6) {
                        int i13 = this.andSelected[j6];
                        this.intermediateNulls[i13] = true;
                    }
                }
            } else if (nextColVector.noNulls) {
                int newSel = 0;
                for (int j7 = 0; j7 < andSel; ++j7) {
                    i4 = this.andSelected[j7];
                    if (nextVector[i4] != 1L) continue;
                    this.andSelected[newSel++] = i4;
                }
                andSel = newSel;
            } else {
                int newSel = 0;
                for (int j8 = 0; j8 < andSel; ++j8) {
                    i4 = this.andSelected[j8];
                    if (nextColVector.isNull[i4]) {
                        this.intermediateNulls[i4] = true;
                        this.andSelected[newSel++] = i4;
                        continue;
                    }
                    if (nextVector[i4] != 1L) continue;
                    this.andSelected[newSel++] = i4;
                }
                andSel = newSel;
            }
            if (++colNum < this.colNums.length) continue;
        }
        if (andRepeating) {
            outV.isRepeating = true;
            if (andRepeatingIsNull) {
                outV.noNulls = false;
                outV.isNull[0] = true;
            } else {
                outputVector[0] = 1L;
            }
        } else if (andSel == 0) {
            outV.isRepeating = true;
            outputVector[0] = 0L;
        } else {
            int andIndex = 0;
            if (batch.selectedInUse) {
                for (int j9 = 0; j9 != n; ++j9) {
                    int i14 = sel[j9];
                    if (andIndex < andSel && this.andSelected[andIndex] == i14) {
                        if (this.intermediateNulls[i14]) {
                            outV.noNulls = false;
                            outV.isNull[i14] = true;
                        } else {
                            outputVector[i14] = 1L;
                        }
                        ++andIndex;
                        continue;
                    }
                    outputVector[i14] = 0L;
                }
                Preconditions.checkState(andIndex == andSel);
            } else {
                Arrays.fill(outputVector, 0, n, 0L);
                for (int j10 = 0; j10 < andSel; ++j10) {
                    int i15 = this.andSelected[j10];
                    if (this.intermediateNulls[i15]) {
                        outV.noNulls = false;
                        outV.isNull[i15] = true;
                        continue;
                    }
                    outputVector[i15] = 1L;
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

