/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.aries.rsa.discovery.endpoint.EndpointDescriptionParser;
import org.apache.aries.rsa.discovery.zookeeper.publish.DiscoveryPlugin;
import org.apache.aries.rsa.discovery.zookeeper.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingEndpointListener
implements EndpointListener {
    private static final Logger LOG = LoggerFactory.getLogger(PublishingEndpointListener.class);
    private final ZooKeeper zk;
    private final ServiceTracker<DiscoveryPlugin, DiscoveryPlugin> discoveryPluginTracker;
    private final List<EndpointDescription> endpoints = new ArrayList<EndpointDescription>();
    private boolean closed;
    private final EndpointDescriptionParser endpointDescriptionParser;

    public PublishingEndpointListener(ZooKeeper zk, BundleContext bctx) {
        this.zk = zk;
        this.discoveryPluginTracker = new ServiceTracker(bctx, DiscoveryPlugin.class, null);
        this.discoveryPluginTracker.open();
        this.endpointDescriptionParser = new EndpointDescriptionParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
        List<EndpointDescription> list = this.endpoints;
        synchronized (list) {
            if (this.closed) {
                return;
            }
            if (this.endpoints.contains(endpoint)) {
                return;
            }
            try {
                this.addEndpoint(endpoint);
                this.endpoints.add(endpoint);
            }
            catch (Exception ex) {
                LOG.error("Exception while processing the addition of an endpoint.", (Throwable)ex);
            }
        }
    }

    private byte[] getData(EndpointDescription epd) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.endpointDescriptionParser.writeEndpoint(epd, (OutputStream)bos);
        return bos.toByteArray();
    }

    private void addEndpoint(EndpointDescription endpoint) throws URISyntaxException, KeeperException, InterruptedException, IOException {
        List interfaces = endpoint.getInterfaces();
        String endpointKey = PublishingEndpointListener.getKey(endpoint);
        HashMap<String, Object> props = new HashMap<String, Object>(endpoint.getProperties());
        Object[] plugins = this.discoveryPluginTracker.getServices();
        if (plugins != null) {
            for (Object plugin : plugins) {
                if (!(plugin instanceof DiscoveryPlugin)) continue;
                endpointKey = ((DiscoveryPlugin)plugin).process(props, endpointKey);
            }
        }
        LOG.info("Exporting endpoint to zookeeper: {}", (Object)endpoint);
        for (String name : interfaces) {
            String path = Utils.getZooKeeperPath(name);
            String fullPath = path + '/' + endpointKey;
            LOG.info("Creating ZooKeeper node for service with path {}", (Object)fullPath);
            PublishingEndpointListener.createPath(path, this.zk);
            this.createEphemeralNode(fullPath, this.getData(endpoint));
        }
    }

    private void createEphemeralNode(String fullPath, byte[] data) throws KeeperException, InterruptedException {
        try {
            this.zk.create(fullPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.info("node for endpoint already exists, recreating: {}", (Object)fullPath);
            try {
                this.zk.delete(fullPath, -1);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            this.zk.create(fullPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
        LOG.info("Local EndpointDescription removed: {}", (Object)endpoint);
        List<EndpointDescription> list = this.endpoints;
        synchronized (list) {
            if (this.closed) {
                return;
            }
            if (!this.endpoints.contains(endpoint)) {
                return;
            }
            try {
                this.removeEndpoint(endpoint);
                this.endpoints.remove(endpoint);
            }
            catch (Exception ex) {
                LOG.error("Exception while processing the removal of an endpoint", (Throwable)ex);
            }
        }
    }

    private void removeEndpoint(EndpointDescription endpoint) throws UnknownHostException, URISyntaxException {
        List interfaces = endpoint.getInterfaces();
        String endpointKey = PublishingEndpointListener.getKey(endpoint);
        for (String name : interfaces) {
            String path = Utils.getZooKeeperPath(name);
            String fullPath = path + '/' + endpointKey;
            LOG.debug("Removing ZooKeeper node: {}", (Object)fullPath);
            try {
                this.zk.delete(fullPath, -1);
            }
            catch (Exception ex) {
                LOG.debug("Error while removing endpoint: {}", (Throwable)ex);
            }
        }
    }

    private static void createPath(String path, ZooKeeper zk) throws KeeperException, InterruptedException {
        StringBuilder current = new StringBuilder();
        List<String> parts = Utils.removeEmpty(Arrays.asList(path.split("/")));
        for (String part : parts) {
            current.append('/');
            current.append(part);
            try {
                zk.create(current.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        }
    }

    private static String getKey(EndpointDescription endpoint) throws URISyntaxException {
        URI uri = new URI(endpoint.getId());
        return uri.getHost() + "#" + uri.getPort() + "#" + uri.getPath().replace('/', '#');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LOG.debug("closing - removing all endpoints");
        List<EndpointDescription> list = this.endpoints;
        synchronized (list) {
            this.closed = true;
            for (EndpointDescription endpoint : this.endpoints) {
                try {
                    this.removeEndpoint(endpoint);
                }
                catch (Exception ex) {
                    LOG.error("Exception while removing endpoint during close", (Throwable)ex);
                }
            }
            this.endpoints.clear();
        }
        this.discoveryPluginTracker.close();
    }
}

