/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TemporaryHashSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.spark.SmallTableCache;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SparkBucketMapJoinContext;
import org.apache.hadoop.mapred.JobConf;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Log LOG = LogFactory.getLog((String)HashTableLoader.class.getName());
    private ExecMapperContext context;
    private Configuration hconf;
    private MapJoinOperator joinOp;
    private MapJoinDesc desc;

    @Override
    public void init(ExecMapperContext context, Configuration hconf, MapJoinOperator joinOp) {
        this.context = context;
        this.hconf = hconf;
        this.joinOp = joinOp;
        this.desc = (MapJoinDesc)joinOp.getConf();
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes, long memUsage) throws HiveException {
        String currentInputPath = this.context.getCurrentInputPath() == null ? null : this.context.getCurrentInputPath().toString();
        LOG.info((Object)("******* Load from HashTable for input file: " + currentInputPath));
        MapredLocalWork localWork = this.context.getLocalWork();
        try {
            Path baseDir;
            if (localWork.getDirectFetchOp() != null) {
                this.loadDirectly(mapJoinTables, currentInputPath);
            }
            if ((baseDir = localWork.getTmpPath()) == null) {
                return;
            }
            FileSystem fs = FileSystem.get((URI)baseDir.toUri(), (Configuration)this.hconf);
            BucketMapJoinContext mapJoinCtx = localWork.getBucketMapjoinContext();
            for (int pos = 0; pos < mapJoinTables.length; ++pos) {
                if (pos == this.desc.getPosBigTable() || mapJoinTables[pos] != null) continue;
                String bigInputPath = currentInputPath;
                if (currentInputPath != null && mapJoinCtx != null) {
                    if (!this.desc.isBucketMapJoin()) {
                        bigInputPath = null;
                    } else {
                        Set<String> aliases = ((SparkBucketMapJoinContext)mapJoinCtx).getPosToAliasMap().get(pos);
                        String alias = aliases.iterator().next();
                        String smallInputPath = mapJoinCtx.getAliasBucketFileNameMapping().get(alias).get(bigInputPath).get(0);
                        bigInputPath = mapJoinCtx.getMappingBigFile(alias, smallInputPath);
                    }
                }
                String fileName = localWork.getBucketFileName(bigInputPath);
                Path path = Utilities.generatePath(baseDir, this.desc.getDumpFilePrefix(), (byte)pos, fileName);
                mapJoinTables[pos] = this.load(fs, path, mapJoinTableSerdes[pos]);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapJoinTableContainer load(FileSystem fs, Path path, MapJoinTableContainerSerDe mapJoinTableSerde) throws HiveException {
        LOG.info((Object)("\tLoad back all hashtable files from tmp folder uri:" + path));
        if (!SparkUtilities.isDedicatedCluster(this.hconf)) {
            return mapJoinTableSerde.load(fs, path);
        }
        MapJoinTableContainer mapJoinTable = SmallTableCache.get(path);
        if (mapJoinTable == null) {
            String string = path.toString().intern();
            synchronized (string) {
                mapJoinTable = SmallTableCache.get(path);
                if (mapJoinTable == null) {
                    mapJoinTable = mapJoinTableSerde.load(fs, path);
                    SmallTableCache.cache(path, mapJoinTable);
                }
            }
        }
        return mapJoinTable;
    }

    private void loadDirectly(MapJoinTableContainer[] mapJoinTables, String inputFileName) throws Exception {
        MapredLocalWork localWork = this.context.getLocalWork();
        List<Operator<? extends OperatorDesc>> directWorks = localWork.getDirectFetchOp().get(this.joinOp);
        if (directWorks == null || directWorks.isEmpty()) {
            return;
        }
        JobConf job = new JobConf(this.hconf);
        MapredLocalTask localTask = new MapredLocalTask(localWork, job, false);
        TemporaryHashSinkOperator sink = new TemporaryHashSinkOperator(this.desc);
        sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>(directWorks));
        for (Operator<? extends OperatorDesc> operator : directWorks) {
            if (operator == null) continue;
            operator.setChildOperators(Arrays.asList(sink));
        }
        localTask.setExecContext(this.context);
        localTask.startForward(inputFileName);
        Object[] tables = sink.getMapJoinTables();
        for (int i = 0; i < sink.getNumParent(); ++i) {
            if (sink.getParentOperators().get(i) == null) continue;
            mapJoinTables[i] = tables[i];
        }
        Arrays.fill(tables, null);
    }
}

