/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionTaskIndependent;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;

public class FSStatsAggregator
implements StatsAggregator,
StatsCollectionTaskIndependent {
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    private List<Map<String, Map<String, String>>> statsList;
    private Map<String, Map<String, String>> statsMap;
    private FileSystem fs;
    private Configuration conf;

    @Override
    public boolean connect(Configuration hconf, Task sourceTask) {
        this.conf = hconf;
        Path statsDir = new Path(hconf.get("hive.stats.tmp.loc"));
        this.LOG.debug((Object)("About to read stats from : " + statsDir));
        this.statsMap = new HashMap<String, Map<String, String>>();
        try {
            FileStatus[] status;
            this.fs = statsDir.getFileSystem(hconf);
            this.statsList = new ArrayList<Map<String, Map<String, String>>>();
            for (FileStatus file : status = this.fs.listStatus(statsDir, new PathFilter(){

                public boolean accept(Path file) {
                    return file.getName().startsWith("tmpstats-");
                }
            })) {
                Input in = new Input((InputStream)this.fs.open(file.getPath()));
                this.statsMap = (Map)Utilities.runtimeSerializationKryo.get().readObject(in, this.statsMap.getClass());
                this.LOG.info((Object)("Read stats : " + this.statsMap));
                this.statsList.add(this.statsMap);
                in.close();
            }
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            return false;
        }
    }

    @Override
    public String aggregateStats(String partID, String statType) {
        long counter = 0L;
        this.LOG.debug((Object)("Part ID: " + partID + "\t" + statType));
        for (Map<String, Map<String, String>> statsMap : this.statsList) {
            String statVal;
            Map<String, String> partStat = statsMap.get(partID);
            if (null == partStat || null == (statVal = partStat.get(statType))) continue;
            counter += Long.valueOf(statVal).longValue();
        }
        this.LOG.info((Object)("Read stats for : " + partID + "\t" + statType + "\t" + counter));
        return String.valueOf(counter);
    }

    @Override
    public boolean closeConnection() {
        this.LOG.debug((Object)"About to delete stats tmp dir");
        try {
            this.fs.delete(new Path(this.conf.get("hive.stats.tmp.loc")), true);
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            return true;
        }
    }

    @Override
    public boolean cleanUp(String keyPrefix) {
        return true;
    }
}

