/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory;

import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.NamedQueryModel;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;

public abstract class QueryNameTextFieldDocumentListener<T>
extends DocumentChangeHandler
implements ListDataListener {
    private boolean inUpdate;
    private NamedQueryModel<T> dialogModel;

    protected QueryNameTextFieldDocumentListener(NamedQueryModel<T> dialogModel) {
        this.dialogModel = dialogModel;
        this.dialogModel.getQueries().addListDataListener(this);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this.inUpdate) {
            return;
        }
        if (e.getIndex0() != -1) {
            return;
        }
        try {
            this.inUpdate = true;
            DataSetQuery<T> selectedQuery = this.dialogModel.getQueries().getSelectedQuery();
            if (selectedQuery == null) {
                this.setEditorQuery(null);
                return;
            }
            this.setEditorQuery(selectedQuery);
        }
        finally {
            this.inUpdate = false;
        }
    }

    protected abstract void setEditorQuery(DataSetQuery<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleChange(DocumentEvent e) {
        if (this.inUpdate) {
            return;
        }
        DataSetQuery<T> item = this.dialogModel.getQueries().getSelectedQuery();
        if (item == null) {
            return;
        }
        try {
            this.inUpdate = true;
            Document document = e.getDocument();
            String queryName = document.getText(0, document.getLength());
            item.setQueryName(queryName);
            this.dialogModel.getQueries().fireItemChanged(item);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        finally {
            this.inUpdate = false;
        }
    }
}

