/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.FormatParser;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DateFormatParser
extends FormatParser {
    private TimeZone timeZone;

    public DateFormatParser() {
        this.setDateFormat(DateFormat.getInstance());
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.getFormatter();
    }

    public void setDateFormat(DateFormat format) {
        super.setFormatter(format);
    }

    @Override
    public void setFormatter(Format format) {
        DateFormat dfmt = (DateFormat)format;
        super.setFormatter(dfmt);
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        TimeZone timeZone = runtime.getResourceBundleFactory().getTimeZone();
        if (!ObjectUtilities.equal((Object)timeZone, (Object)this.timeZone)) {
            this.timeZone = timeZone;
            this.getDateFormat().setTimeZone(timeZone);
        }
        return super.getValue(runtime, element);
    }

    @Override
    public void setNullValue(Object nullvalue) {
        Date dt = (Date)nullvalue;
        super.setNullValue(dt);
    }

    @Override
    protected boolean isValidOutput(Object o) {
        return o instanceof Date;
    }
}

