/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.build;

import org.pentaho.reporting.engine.classic.core.layout.build.LayoutModelBuilderContext;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public class BandSectionLayoutModelBuilderContext
implements LayoutModelBuilderContext,
Cloneable {
    private LayoutModelBuilderContext parent;
    private RenderBox renderBox;
    private boolean empty;
    private boolean keepWrapperBoxAlive;
    private boolean autoGeneratedWrapperBox;
    private boolean strictCompatibilityMode;
    private boolean committedAsEmpty;

    public BandSectionLayoutModelBuilderContext(OutputProcessorMetaData metaData, LayoutModelBuilderContext parent, RenderBox renderBox) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (renderBox == null) {
            throw new NullPointerException();
        }
        this.strictCompatibilityMode = metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY);
        this.parent = parent;
        this.renderBox = renderBox;
        this.empty = true;
        if ((renderBox.getNodeType() == 524290 || this.strictCompatibilityMode && renderBox.getNodeType() == 69650) && parent != null && renderBox.getParent() == null) {
            this.committedAsEmpty = true;
            parent.addChild(renderBox);
        }
    }

    @Override
    public RenderBox getRenderBox() {
        return this.renderBox;
    }

    @Override
    public LayoutModelBuilderContext getParent() {
        return this.parent;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public boolean mergeSection(ReportStateKey stateKey) {
        return false;
    }

    @Override
    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public boolean isKeepWrapperBoxAlive() {
        return this.keepWrapperBoxAlive;
    }

    @Override
    public void setKeepWrapperBoxAlive(boolean keepWrapperBoxAlive) {
        this.keepWrapperBoxAlive = keepWrapperBoxAlive;
    }

    @Override
    public boolean isAutoGeneratedWrapperBox() {
        return this.autoGeneratedWrapperBox;
    }

    @Override
    public void setAutoGeneratedWrapperBox(boolean autoGeneratedWrapperBox) {
        this.autoGeneratedWrapperBox = autoGeneratedWrapperBox;
    }

    @Override
    public void addChild(RenderBox child) {
        this.renderBox.addChild(child);
    }

    @Override
    public void removeChild(RenderBox child) {
        this.renderBox.remove(child);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public LayoutModelBuilderContext deriveForPagebreak() {
        BandSectionLayoutModelBuilderContext clone = (BandSectionLayoutModelBuilderContext)this.clone();
        if (this.parent != null) {
            clone.parent = this.parent.deriveForPagebreak();
        }
        return clone;
    }

    @Override
    public LayoutModelBuilderContext deriveForStorage(RenderBox clonedRoot) {
        if (clonedRoot == null) {
            throw new NullPointerException();
        }
        BandSectionLayoutModelBuilderContext clone = (BandSectionLayoutModelBuilderContext)this.clone();
        if (this.parent == null) {
            clone.renderBox = clonedRoot;
        } else {
            clone.parent = this.parent.deriveForStorage(clonedRoot);
            clone.renderBox = (RenderBox)this.renderBox.derive(true);
        }
        return clone;
    }

    @Override
    public void validateAfterCommit() {
    }

    @Override
    public void performParanoidModelCheck() {
    }

    @Override
    public void restoreStateAfterRollback() {
    }

    @Override
    public void commitAsEmpty() {
    }

    public void undoCommit() {
        if (!this.committedAsEmpty) {
            return;
        }
        this.getParent().removeChild(this.getRenderBox());
    }

    @Override
    public LayoutModelBuilderContext close() {
        LayoutModelBuilderContext parentContext = this.getParent();
        RenderBox sectionBox = this.getRenderBox();
        RenderNode firstChild = sectionBox.getFirstChild();
        if (firstChild == null) {
            this.undoCommit();
            return parentContext;
        }
        int type = firstChild.getNodeType();
        if (parentContext != null && sectionBox.getLastChild() == firstChild && (type == 16777282 || type == 0x1000012) && parentContext.mergeSection(firstChild.getStateKey())) {
            this.undoCommit();
            return parentContext;
        }
        this.renderBox.close();
        if (!this.isEmpty()) {
            if (parentContext != null && sectionBox.getParent() == null) {
                if (!this.committedAsEmpty) {
                    parentContext.addChild(sectionBox);
                }
                parentContext.setEmpty(false);
            }
        } else if (this.committedAsEmpty && parentContext != null && parentContext.mergeSection(firstChild.getStateKey())) {
            this.undoCommit();
        }
        return parentContext;
    }

    @Override
    public int getDepth() {
        if (this.parent == null) {
            return 1;
        }
        return 1 + this.parent.getDepth();
    }
}

