/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportProcessTask;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultReportProcessTaskMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ReportProcessTaskMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportProcessTaskReadHandler
extends AbstractMetaDataReadHandler {
    private ArrayList<StringReadHandler> aliasReadHandlers = new ArrayList();
    private ReportProcessTaskMetaDataBuilder builder = new ReportProcessTaskMetaDataBuilder();

    public ReportProcessTaskMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().implementation(this.parseImpl(attrs));
        this.getBuilder().bundle(this.getBundle(), "");
    }

    private Class<? extends ReportProcessTask> parseImpl(Attributes attrs) throws ParseException {
        String implText = attrs.getValue(this.getUri(), "class");
        if (implText == null) {
            throw new ParseException("Attribute 'class' is undefined", this.getLocator());
        }
        try {
            Class c = ObjectUtilities.loadAndValidate((String)implText, ReportProcessTaskReadHandler.class, ReportProcessTask.class);
            if (c == null) {
                throw new ParseException("Attribute 'class' is not valid", this.getLocator());
            }
            return c;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Attribute 'class' is not valid", e, this.getLocator());
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("alias".equals(tagName)) {
            StringReadHandler rh = new StringReadHandler();
            this.aliasReadHandlers.add(rh);
            return rh;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.aliasReadHandlers.size(); ++i) {
            StringReadHandler readHandler = this.aliasReadHandlers.get(i);
            this.getBuilder().alias(readHandler.getResult());
        }
    }

    public ReportProcessTaskMetaData getObject() throws SAXException {
        return new DefaultReportProcessTaskMetaData(this.getBuilder());
    }
}

