/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.SwingPreviewModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportEventSource;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class GoToFirstPageActionPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources;
    private ReportEventSource eventSource;
    private PageUpdateListener updateListener = new PageUpdateListener();

    @Override
    public void deinitialize(SwingGuiContext swingGuiContext) {
        super.deinitialize(swingGuiContext);
        swingGuiContext.getEventSource().removePropertyChangeListener(this.updateListener);
    }

    @Override
    public boolean initialize(SwingGuiContext context) {
        super.initialize(context);
        this.resources = new ResourceBundleSupport(context.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(SwingPreviewModule.class));
        this.eventSource = context.getEventSource();
        this.eventSource.addPropertyChangeListener(this.updateListener);
        this.revalidate();
        return true;
    }

    private void revalidate() {
        if (!this.eventSource.isPaginated()) {
            this.setEnabled(false);
            return;
        }
        if (this.eventSource.getPageNumber() <= 1) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.base.go-to-first.";
    }

    @Override
    public String getDisplayName() {
        return this.resources.getString("action.firstpage.name");
    }

    @Override
    public String getShortDescription() {
        return this.resources.getString("action.firstpage.description");
    }

    @Override
    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.firstpage.small-icon");
    }

    @Override
    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.firstpage.icon");
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.firstpage.accelerator");
    }

    @Override
    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.firstpage.mnemonic");
    }

    @Override
    public boolean configure(PreviewPane reportPane) {
        reportPane.setPageNumber(1);
        return true;
    }

    private class PageUpdateListener
    implements PropertyChangeListener {
        protected PageUpdateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GoToFirstPageActionPlugin.this.revalidate();
        }
    }
}

