/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls;

import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTableContentProducer;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class FlowExcelOutputProcessor
extends AbstractTableOutputProcessor {
    private OutputProcessorMetaData metaData;
    private FlowSelector flowSelector;
    private ExcelPrinter printer;

    public FlowExcelOutputProcessor(Configuration config, OutputStream outputStream, ResourceManager resourceManager) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.metaData = new ExcelOutputProcessorMetaData(1);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new ExcelPrinter(outputStream, resourceManager);
    }

    public boolean isUseXlsxFormat() {
        return this.printer.isUseXlsxFormat();
    }

    public void setUseXlsxFormat(boolean useXlsxFormat) {
        this.printer.setUseXlsxFormat(useXlsxFormat);
    }

    public InputStream getTemplateInputStream() {
        return this.printer.getTemplateInputStream();
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.printer.setTemplateInputStream(templateInputStream);
    }

    @Override
    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    @Override
    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    @Override
    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        if (!this.printer.isInitialized()) {
            this.printer.init(this.metaData);
        }
        this.printer.print(logicalPageKey, logicalPage, contentProducer, false);
    }

    @Override
    protected void updateTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox, TableContentProducer tableContentProducer, boolean performOutput) throws ContentProcessingException {
        if (!this.printer.isInitialized()) {
            this.printer.init(this.metaData);
        }
        this.printer.print(logicalPageKey, logicalPageBox, tableContentProducer, true);
    }

    @Override
    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        if (!this.printer.isInitialized()) {
            this.printer.init(this.metaData);
        }
        this.metaData.commit();
        this.printer.close();
    }

    @Override
    protected TableContentProducer createTableContentProducer(SheetLayout layout) {
        return new ExcelTableContentProducer(layout, this.getMetaData());
    }
}

