/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.FontSmooth;
import org.pentaho.reporting.engine.classic.core.style.TextDirection;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.style.VerticalTextAlign;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextStyleReadHandler
extends AbstractXmlReadHandler
implements StyleReadHandler {
    private static final Log logger = LogFactory.getLog(TextStyleReadHandler.class);
    private ElementStyleSheet styleSheet;

    public ElementStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @Override
    public void setStyleSheet(ElementStyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String textIndent;
        String firstLineIndent;
        String verticalTextAlignment;
        String fontSmooth;
        String textDirection;
        String textWrap;
        String wsCollapse;
        String excelIndention;
        String excelTextWrap;
        String trimTextContent;
        String fontStrikethrough;
        String fontUnderline;
        String fontItalics;
        String fontEmbedded;
        String fontBold;
        String lineHeight;
        String fontSize;
        String fontEncoding;
        String reservedLiteral;
        String optimumLetterSpacing;
        String maxLetterSpacing;
        String minLetterSpacing;
        String wordSpacing = attrs.getValue(this.getUri(), "word-spacing");
        if (wordSpacing != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.WORD_SPACING, ReportParserUtil.parseFloat(wordSpacing, this.getLocator()));
        }
        if ((minLetterSpacing = attrs.getValue(this.getUri(), "min-letter-spacing")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.X_MIN_LETTER_SPACING, ReportParserUtil.parseFloat(minLetterSpacing, this.getLocator()));
        }
        if ((maxLetterSpacing = attrs.getValue(this.getUri(), "max-letter-spacing")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.X_MAX_LETTER_SPACING, ReportParserUtil.parseFloat(maxLetterSpacing, this.getLocator()));
        }
        if ((optimumLetterSpacing = attrs.getValue(this.getUri(), "optimum-letter-spacing")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, ReportParserUtil.parseFloat(optimumLetterSpacing, this.getLocator()));
        }
        if ("UTF-8".equals(reservedLiteral = attrs.getValue(this.getUri(), "ellipsis"))) {
            logger.info((Object)"Auto-corrected invalid ellipsis text [PRD-3315]");
            this.styleSheet.setStyleProperty(TextStyleKeys.RESERVED_LITERAL, null);
        } else if (reservedLiteral != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.RESERVED_LITERAL, reservedLiteral);
        }
        String fontName = attrs.getValue(this.getUri(), "font-face");
        if (fontName != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.FONT, fontName);
        }
        if ((fontEncoding = attrs.getValue(this.getUri(), "encoding")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.FONTENCODING, fontEncoding);
        }
        if ((fontSize = attrs.getValue(this.getUri(), "font-size")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.FONTSIZE, ReportParserUtil.parseInteger(fontSize, this.getLocator()));
        }
        if ((lineHeight = attrs.getValue(this.getUri(), "line-height")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.LINEHEIGHT, ReportParserUtil.parseFloat(lineHeight, this.getLocator()));
        }
        if ((fontBold = attrs.getValue(this.getUri(), "bold")) != null) {
            this.styleSheet.setBooleanStyleProperty(TextStyleKeys.BOLD, "true".equals(fontBold));
        }
        if ((fontEmbedded = attrs.getValue(this.getUri(), "embedded")) != null) {
            this.styleSheet.setBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT, "true".equals(fontEmbedded));
        }
        if ((fontItalics = attrs.getValue(this.getUri(), "italic")) != null) {
            this.styleSheet.setBooleanStyleProperty(TextStyleKeys.ITALIC, "true".equals(fontItalics));
        }
        if ((fontUnderline = attrs.getValue(this.getUri(), "underline")) != null) {
            this.styleSheet.setBooleanStyleProperty(TextStyleKeys.UNDERLINED, "true".equals(fontUnderline));
        }
        if ((fontStrikethrough = attrs.getValue(this.getUri(), "strikethrough")) != null) {
            this.styleSheet.setBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH, "true".equals(fontStrikethrough));
        }
        if ((trimTextContent = attrs.getValue(this.getUri(), "trim-text-content")) != null) {
            this.styleSheet.setBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT, "true".equals(trimTextContent));
        }
        if ((excelTextWrap = attrs.getValue(this.getUri(), "excel-text-wrapping")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.EXCEL_WRAP_TEXT, "true".equals(excelTextWrap));
        }
        if ((excelIndention = attrs.getValue(this.getUri(), "excel-text-indention")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.EXCEL_INDENTION, ReportParserUtil.parseInteger(excelIndention, this.getLocator()).shortValue());
        }
        if ((wsCollapse = attrs.getValue(this.getUri(), "whitespace-collapse")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE, this.parseWhitespaceCollapse(wsCollapse));
        }
        if ((textWrap = attrs.getValue(this.getUri(), "text-wrap")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.TEXT_WRAP, this.parseTextWrap(textWrap));
        }
        if ((textDirection = attrs.getValue(this.getUri(), "direction")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.DIRECTION, this.parseTextDirection(textDirection));
        }
        if ((fontSmooth = attrs.getValue(this.getUri(), "font-smooth")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.FONT_SMOOTH, this.parseFontSmooth(fontSmooth));
        }
        if ((verticalTextAlignment = attrs.getValue(this.getUri(), "vertical-text-alignment")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT, this.parseVerticalTextAlign(verticalTextAlignment));
        }
        if ((firstLineIndent = attrs.getValue(this.getUri(), "first-line-indent")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.FIRST_LINE_INDENT, ReportParserUtil.parseFloat(firstLineIndent, this.getLocator()));
        }
        if ((textIndent = attrs.getValue(this.getUri(), "text-indent")) != null) {
            this.styleSheet.setStyleProperty(TextStyleKeys.TEXT_INDENT, ReportParserUtil.parseFloat(textIndent, this.getLocator()));
        }
    }

    private WhitespaceCollapse parseWhitespaceCollapse(String attr) {
        if (WhitespaceCollapse.DISCARD.toString().equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.DISCARD;
        }
        if (WhitespaceCollapse.COLLAPSE.toString().equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.COLLAPSE;
        }
        if (WhitespaceCollapse.PRESERVE.toString().equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.PRESERVE;
        }
        if (WhitespaceCollapse.PRESERVE_BREAKS.toString().equalsIgnoreCase(attr)) {
            return WhitespaceCollapse.PRESERVE_BREAKS;
        }
        return null;
    }

    private VerticalTextAlign parseVerticalTextAlign(String attr) {
        if (VerticalTextAlign.USE_SCRIPT.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.USE_SCRIPT;
        }
        if (VerticalTextAlign.TEXT_BOTTOM.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.TEXT_BOTTOM;
        }
        if (VerticalTextAlign.BOTTOM.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.BOTTOM;
        }
        if (VerticalTextAlign.TEXT_TOP.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.TEXT_TOP;
        }
        if (VerticalTextAlign.TOP.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.TOP;
        }
        if (VerticalTextAlign.CENTRAL.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.CENTRAL;
        }
        if (VerticalTextAlign.MIDDLE.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.MIDDLE;
        }
        if (VerticalTextAlign.SUB.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.SUB;
        }
        if (VerticalTextAlign.SUPER.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.SUPER;
        }
        if (VerticalTextAlign.BASELINE.toString().equalsIgnoreCase(attr)) {
            return VerticalTextAlign.BASELINE;
        }
        return null;
    }

    private FontSmooth parseFontSmooth(String attr) {
        if (FontSmooth.ALWAYS.toString().equalsIgnoreCase(attr)) {
            return FontSmooth.ALWAYS;
        }
        if (FontSmooth.NEVER.toString().equalsIgnoreCase(attr)) {
            return FontSmooth.NEVER;
        }
        return FontSmooth.AUTO;
    }

    private TextWrap parseTextWrap(String attr) {
        if (TextWrap.WRAP.toString().equalsIgnoreCase(attr)) {
            return TextWrap.WRAP;
        }
        if (TextWrap.NONE.toString().equalsIgnoreCase(attr)) {
            return TextWrap.NONE;
        }
        return TextWrap.WRAP;
    }

    private TextDirection parseTextDirection(String o) {
        if (TextDirection.LTR.toString().equalsIgnoreCase(o)) {
            return TextDirection.LTR;
        }
        if (TextDirection.RTL.toString().equalsIgnoreCase(o)) {
            return TextDirection.RTL;
        }
        return TextDirection.LTR;
    }

    public Object getObject() throws SAXException {
        return this.styleSheet;
    }
}

