/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.objecttunnel;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import org.pentaho.osgi.objecttunnel.TunnelSerializer;
import org.pentaho.osgi.objecttunnel.TunneledInputObject;
import org.pentaho.osgi.objecttunnel.TunneledPayload;
import org.reactivestreams.Subscriber;

public class TunnelOutput
implements AutoCloseable {
    private ObjectOutputStream output;
    private Map<Class, TunnelSerializer> serializerMap = new HashMap<Class, TunnelSerializer>();
    private List<Subscriber<? super TunneledInputObject>> subscribers = new ArrayList<Subscriber<? super TunneledInputObject>>();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile int errorThreshold = 5;

    public TunnelOutput(ObjectOutputStream output, Map<Class, TunnelSerializer> serializerMap) {
        this.output = output;
        this.serializerMap.putAll(serializerMap);
    }

    @Override
    public void close() throws Exception {
        this.closed.set(true);
        this.output.close();
    }

    void setSerializer(Class clazz, final Function<Object, String> serializer) {
        this.serializerMap.put(clazz, new TunnelSerializer(){

            @Override
            public List<Class> getSupportedClasses() {
                return null;
            }

            @Override
            public String serialize(Object object) {
                return (String)serializer.apply(object);
            }

            public Object deserialize(String serializedString) {
                return null;
            }
        });
    }

    public void writeObject(Object object) throws IOException {
        Class<?> type = object.getClass();
        if (!this.serializerMap.containsKey(type)) {
            throw new IllegalArgumentException("No Serialize Function for given type: " + type);
        }
        if (object == null) {
            throw new NullPointerException("Given TunnelInput Object is null");
        }
        try {
            Stream.of(this.serializerMap.get(type)).map(s -> s.serialize(object)).map(o -> new TunneledPayload(type.getName(), (String)o)).forEach(o -> {
                try {
                    this.output.writeObject(o);
                }
                catch (IOException e) {
                    throw new ExceptionWrapper(e);
                }
            });
        }
        catch (ExceptionWrapper wrapper) {
            throw wrapper.ioe;
        }
    }

    private static class ExceptionWrapper
    extends RuntimeException {
        IOException ioe;

        ExceptionWrapper(IOException e) {
            super(e);
            this.ioe = e;
        }
    }
}

