/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Time;

@InterfaceStability.Evolving
public class ThreadUtil {
    private static final Log LOG = LogFactory.getLog(ThreadUtil.class);

    public static void sleepAtLeastIgnoreInterrupts(long millis) {
        long start = Time.now();
        while (Time.now() - start < millis) {
            long timeToSleep = millis - (Time.now() - start);
            try {
                Thread.sleep(timeToSleep);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"interrupted while sleeping", (Throwable)ie);
            }
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new IOException("Can not read resource file '" + resourceName + "' because class loader of the current thread is null");
        }
        InputStream is = cl.getResourceAsStream(resourceName);
        if (is == null) {
            throw new IOException("Can not read resource file '" + resourceName + "'");
        }
        return is;
    }
}

