/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.fileio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.ISourcesStreamEvents;
import org.pentaho.platform.api.repository2.unified.IStreamListener;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.util.web.MimeHelper;

public class RepositoryFileOutputStream
extends ByteArrayOutputStream
implements ISourcesStreamEvents {
    protected boolean hidden = false;
    protected String path = null;
    protected IUnifiedRepository repository;
    protected String charsetName = null;
    protected boolean autoCreateUniqueFileName = false;
    protected boolean autoCreateDirStructure = false;
    protected boolean closed = false;
    protected boolean flushed = false;
    protected ArrayList<IStreamListener> listeners = new ArrayList();

    public RepositoryFileOutputStream(String path, boolean autoCreateUniqueFileName, boolean autoCreateDirStructure, IUnifiedRepository repository, boolean hidden) {
        this.setRepository(repository);
        this.path = path;
        this.hidden = hidden;
        this.autoCreateDirStructure = autoCreateDirStructure;
        this.autoCreateUniqueFileName = autoCreateUniqueFileName;
    }

    public RepositoryFileOutputStream(Serializable id, boolean autoCreateUniqueFileName, boolean autoCreateDirStructure, IUnifiedRepository repository, boolean hidden) throws FileNotFoundException {
        this.setRepository(repository);
        RepositoryFile file = this.repository.getFileById(id);
        if (file == null) {
            throw new FileNotFoundException(MessageFormat.format("Repository file with id {0} not readable or does not exist", id));
        }
        this.hidden = hidden;
        this.path = file.getPath();
        this.autoCreateDirStructure = autoCreateDirStructure;
        this.autoCreateUniqueFileName = autoCreateUniqueFileName;
    }

    public RepositoryFileOutputStream(RepositoryFile file, boolean autoCreateUniqueFileName, boolean autoCreateDirStructure, IUnifiedRepository repository) {
        this(file.getPath(), autoCreateUniqueFileName, autoCreateDirStructure, repository, false);
    }

    public RepositoryFileOutputStream(String path, boolean autoCreateUniqueFileName, boolean autoCreateDirStructure) {
        this(path, autoCreateUniqueFileName, autoCreateDirStructure, null, false);
    }

    public RepositoryFileOutputStream(Serializable id, boolean autoCreateUniqueFileName, boolean autoCreateDirStructure) throws FileNotFoundException {
        this(id, autoCreateUniqueFileName, autoCreateDirStructure, null, false);
    }

    public RepositoryFileOutputStream(RepositoryFile file, boolean autoCreateUniqueFileName, boolean autoCreateDirStructure) {
        this(file, autoCreateUniqueFileName, autoCreateDirStructure, null);
    }

    public RepositoryFileOutputStream(String path) {
        this(path, false, false, null, false);
    }

    public RepositoryFileOutputStream(String path, boolean hidden) {
        this(path, false, false, null, hidden);
    }

    public RepositoryFileOutputStream(RepositoryFile file) {
        this(file.getPath(), false, false, null, (boolean)file.isHidden());
    }

    public RepositoryFileOutputStream(Serializable id) throws FileNotFoundException {
        this(id, false, false, null, false);
    }

    protected RepositoryFileOutputStream(String path, String charsetName) throws FileNotFoundException {
        this(path);
        this.charsetName = charsetName;
    }

    protected RepositoryFileOutputStream(RepositoryFile file, String charsetName) throws FileNotFoundException {
        this(file);
        this.charsetName = charsetName;
    }

    protected RepositoryFileOutputStream(Serializable id, String charsetName) throws FileNotFoundException {
        this(id);
        this.charsetName = charsetName;
    }

    protected RepositoryFile getParent(String path) {
        String newFilePath = StringUtils.removeEnd((String)path, (String)"/");
        String parentPath = StringUtils.substringBeforeLast((String)newFilePath, (String)"/");
        if (parentPath.isEmpty()) {
            parentPath = "/";
        }
        return this.repository.getFile(parentPath);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
            this.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        String tempMimeType;
        if (this.closed) {
            return;
        }
        super.flush();
        ByteArrayInputStream bis = new ByteArrayInputStream(this.toByteArray());
        String ext = RepositoryFilenameUtils.getExtension(this.path);
        String mimeType = "application/octet-stream";
        if (ext != null && (tempMimeType = MimeHelper.getMimeTypeFromExtension((String)("." + ext))) != null) {
            mimeType = tempMimeType;
        }
        if (this.charsetName == null && mimeType != null) {
            this.charsetName = MimeHelper.getDefaultCharset((String)mimeType);
        }
        SimpleRepositoryFileData payload = new SimpleRepositoryFileData((InputStream)bis, this.charsetName, mimeType);
        if (!this.flushed) {
            RepositoryFile file = this.repository.getFile(this.path);
            RepositoryFile parentFolder = this.getParent(this.path);
            String baseFileName = RepositoryFilenameUtils.getBaseName(this.path);
            String extension = RepositoryFilenameUtils.getExtension(this.path);
            if (file == null) {
                if (this.autoCreateDirStructure) {
                    ArrayList<String> foldersToCreate = new ArrayList<String>();
                    String parentPath = RepositoryFilenameUtils.getFullPathNoEndSeparator(this.path);
                    while (parentPath != null && parentPath.length() > 0 && !this.path.equals(parentPath) && this.repository.getFile(parentPath) == null) {
                        foldersToCreate.add(RepositoryFilenameUtils.getName(parentPath));
                        parentPath = RepositoryFilenameUtils.getFullPathNoEndSeparator(parentPath);
                    }
                    Collections.reverse(foldersToCreate);
                    RepositoryFile repositoryFile = parentFolder = parentPath != null && parentPath.length() > 0 ? this.repository.getFile(parentPath) : this.repository.getFile("/");
                    if (!parentFolder.isFolder()) {
                        throw new FileNotFoundException();
                    }
                    Iterator iterator = foldersToCreate.iterator();
                    while (iterator.hasNext()) {
                        String folderName = (String)iterator.next();
                        parentFolder = this.repository.createFolder(parentFolder.getId(), new RepositoryFile.Builder(folderName).folder(true).build(), null);
                    }
                } else if (parentFolder == null) {
                    throw new FileNotFoundException();
                }
                file = new RepositoryFile.Builder(RepositoryFilenameUtils.getName(this.path)).hidden(this.hidden).versioned(true).build();
                file = this.repository.createFile(parentFolder.getId(), file, (IRepositoryFileData)payload, "commit from " + RepositoryFileOutputStream.class.getName());
                for (IStreamListener listener : this.listeners) {
                    listener.fileCreated(this.path);
                }
            } else {
                if (file.isFolder()) {
                    throw new FileNotFoundException(MessageFormat.format("Repository file {0} is a directory", file.getPath()));
                }
                if (this.autoCreateUniqueFileName) {
                    int nameCount = 1;
                    String newFileName = null;
                    List children = this.repository.getChildren(parentFolder.getId());
                    boolean hasFile = true;
                    block3: while (hasFile) {
                        hasFile = false;
                        newFileName = extension != null && extension.length() > 0 ? baseFileName + "(" + nameCount + ")." + extension : baseFileName + "(" + ++nameCount + ")";
                        for (RepositoryFile child : children) {
                            if (!child.getPath().equals(parentFolder.getPath() + "/" + newFileName)) continue;
                            hasFile = true;
                            continue block3;
                        }
                    }
                    file = new RepositoryFile.Builder(newFileName).versioned(true).build();
                    file = this.repository.createFile(parentFolder.getId(), file, (IRepositoryFileData)payload, "New File");
                    this.path = file.getPath();
                    for (IStreamListener listener : this.listeners) {
                        listener.fileCreated(this.path);
                    }
                } else {
                    this.repository.updateFile(file, (IRepositoryFileData)payload, "New File");
                    this.path = file.getPath();
                    for (IStreamListener listener : this.listeners) {
                        listener.fileCreated(this.path);
                    }
                }
            }
        } else {
            RepositoryFile file = this.repository.getFile(this.path);
            this.repository.updateFile(file, (IRepositoryFileData)payload, "New File");
        }
        this.flushed = true;
    }

    public String getFilePath() {
        return this.path;
    }

    public void setFilePath(String path) {
        if (!path.equals(this.path)) {
            this.path = path;
            this.reset();
            this.flushed = false;
            this.closed = false;
        }
    }

    public boolean getAutoCreateUniqueFileName() {
        return this.autoCreateUniqueFileName;
    }

    public boolean getAutoCreateDirStructure() {
        return this.autoCreateDirStructure;
    }

    public void setAutoCreateDirStructure(boolean autoCreateDirStructure) {
        this.autoCreateDirStructure = autoCreateDirStructure;
    }

    public void addListener(IStreamListener listener) {
        this.listeners.add(listener);
    }

    public void setRepository(IUnifiedRepository repository) {
        this.repository = repository != null ? repository : (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
    }

    public IUnifiedRepository getRepository() {
        return this.repository;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean isFlushed() {
        return this.flushed;
    }
}

