/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.dialog;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.ui.core.dialog.ConfigurationDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;

public class JobExecutionConfigurationDialog
extends ConfigurationDialog {
    private static Class<?> PKG = JobExecutionConfigurationDialog.class;
    private Button wExpandRemote;
    private CCombo wStartCopy;

    public JobExecutionConfigurationDialog(Shell parent, JobExecutionConfiguration configuration, JobMeta jobMeta) {
        super(parent, (ExecutionConfiguration)configuration, (AbstractMeta)jobMeta);
    }

    @Override
    protected void serverOptionsComposite(Class<?> PKG, String prefix) {
        this.wlRemoteHost = new Label(this.serverOptionsComposite, 0);
        this.props.setLook((Control)this.wlRemoteHost);
        this.wlRemoteHost.setText(BaseMessages.getString(PKG, (String)(prefix + ".RemoteHost.Label"), (String[])new String[0]));
        this.wlRemoteHost.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".RemoteHost.Tooltip"), (String[])new String[0]));
        FormData fdlRemoteHost = new FormData();
        fdlRemoteHost.top = new FormAttachment(0, 10);
        fdlRemoteHost.left = new FormAttachment((Control)this.environmentSeparator, 5);
        this.wlRemoteHost.setLayoutData((Object)fdlRemoteHost);
        this.wRemoteHost = new CCombo(this.serverOptionsComposite, 2048);
        this.wRemoteHost.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".RemoteHost.Tooltip"), (String[])new String[0]));
        this.props.setLook((Control)this.wRemoteHost);
        FormData fdRemoteHost = new FormData();
        fdRemoteHost.left = new FormAttachment((Control)this.wlRemoteHost, 0, 16384);
        fdRemoteHost.width = 170;
        fdRemoteHost.top = new FormAttachment((Control)this.wlRemoteHost, 8);
        this.wRemoteHost.setLayoutData((Object)fdRemoteHost);
        for (int i = 0; i < this.abstractMeta.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)this.abstractMeta.getSlaveServers().get(i);
            this.wRemoteHost.add(slaveServer.toString());
        }
        this.wPassExport = new Button(this.serverOptionsComposite, 32);
        this.wPassExport.setText(BaseMessages.getString(PKG, (String)(prefix + ".PassExport.Label"), (String[])new String[0]));
        this.wPassExport.setToolTipText(BaseMessages.getString(PKG, (String)(prefix + ".PassExport.Tooltip"), (String[])new String[0]));
        this.props.setLook((Control)this.wPassExport);
        FormData fdPassExport = new FormData();
        fdPassExport.left = new FormAttachment((Control)this.wRemoteHost, 0, 16384);
        fdPassExport.top = new FormAttachment((Control)this.wRemoteHost, 8);
        this.wPassExport.setLayoutData((Object)fdPassExport);
        this.wExpandRemote = new Button(this.serverOptionsComposite, 32);
        this.wExpandRemote.setText(BaseMessages.getString(PKG, (String)(prefix + ".ExpandRemote.Label"), (String[])new String[0]));
        this.wExpandRemote.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ExpandRemote.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExpandRemote);
        FormData fd_expandCheckButton = new FormData();
        fd_expandCheckButton.bottom = new FormAttachment((Control)this.wPassExport, 0, 1024);
        fd_expandCheckButton.left = new FormAttachment((Control)this.wPassExport, 45);
        this.wExpandRemote.setLayoutData((Object)fd_expandCheckButton);
    }

    @Override
    protected void optionsSectionControls() {
        this.wClearLog = new Button((Composite)this.gDetails, 32);
        this.wClearLog.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ClearLog.Label", (String[])new String[0]));
        this.wClearLog.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.ClearLog.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wClearLog);
        FormData fdClearLog = new FormData();
        fdClearLog.top = new FormAttachment(0, 10);
        fdClearLog.left = new FormAttachment(0, 10);
        this.wClearLog.setLayoutData((Object)fdClearLog);
        this.wSafeMode = new Button((Composite)this.gDetails, 32);
        this.wSafeMode.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.SafeMode.Label", (String[])new String[0]));
        this.wSafeMode.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.SafeMode.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSafeMode);
        FormData fdSafeMode = new FormData();
        fdSafeMode.top = new FormAttachment((Control)this.wClearLog, 7);
        fdSafeMode.left = new FormAttachment(0, 10);
        this.wSafeMode.setLayoutData((Object)fdSafeMode);
        this.wGatherMetrics = new Button((Composite)this.gDetails, 32);
        this.wGatherMetrics.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.GatherMetrics.Label", (String[])new String[0]));
        this.wGatherMetrics.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.GatherMetrics.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wGatherMetrics);
        FormData fdGatherMetrics = new FormData();
        fdGatherMetrics.top = new FormAttachment((Control)this.wSafeMode, 7);
        fdGatherMetrics.left = new FormAttachment(0, 10);
        fdGatherMetrics.bottom = new FormAttachment(100, -10);
        this.wGatherMetrics.setLayoutData((Object)fdGatherMetrics);
        this.wlLogLevel = new Label((Composite)this.gDetails, 131072);
        this.wlLogLevel.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LogLevel.Label", (String[])new String[0]));
        this.wlLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlLogLevel);
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.top = new FormAttachment(0, 10);
        fdlLogLevel.left = new FormAttachment(45, 0);
        this.wlLogLevel.setLayoutData((Object)fdlLogLevel);
        this.wLogLevel = new CCombo((Composite)this.gDetails, 2056);
        this.wLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogLevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.top = new FormAttachment((Control)this.wlLogLevel, -2, 128);
        fdLogLevel.width = 180;
        fdLogLevel.left = new FormAttachment((Control)this.wlLogLevel, 6);
        this.wLogLevel.setLayoutData((Object)fdLogLevel);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        Label lblStartJob = new Label((Composite)this.gDetails, 131072);
        lblStartJob.setText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.StartCopy.Label", (String[])new String[0]));
        lblStartJob.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.StartCopy.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)lblStartJob);
        FormData fd_lblStartJob = new FormData();
        fd_lblStartJob.top = new FormAttachment((Control)this.wlLogLevel, 18);
        fd_lblStartJob.right = new FormAttachment((Control)this.wlLogLevel, 0, 131072);
        lblStartJob.setLayoutData((Object)fd_lblStartJob);
        this.wStartCopy = new CCombo((Composite)this.gDetails, 2056);
        this.wStartCopy.setToolTipText(BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.StartCopy.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wStartCopy);
        FormData fd_startJobCombo = new FormData();
        fd_startJobCombo.top = new FormAttachment((Control)lblStartJob, -2, 128);
        fd_startJobCombo.width = 180;
        fd_startJobCombo.left = new FormAttachment((Control)lblStartJob, 6);
        this.wStartCopy.setLayoutData((Object)fd_startJobCombo);
        JobMeta jobMeta = (JobMeta)this.abstractMeta;
        String[] names = new String[jobMeta.getJobCopies().size()];
        for (int i = 0; i < names.length; ++i) {
            JobEntryCopy copy = (JobEntryCopy)jobMeta.getJobCopies().get(i);
            names[i] = this.getJobEntryCopyName(copy);
        }
        this.wStartCopy.setItems(names);
    }

    public boolean open() {
        this.mainLayout(PKG, "JobExecutionConfigurationDialog", GUIResource.getInstance().getImageJobGraph());
        this.environmentTypeSectionLayout(PKG, "JobExecutionConfigurationDialog");
        this.optionsSectionLayout(PKG, "JobExecutionConfigurationDialog");
        this.parametersSectionLayout(PKG, "JobExecutionConfigurationDialog");
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(Spoon.class, (String)"Spoon.JobExecutionConfigurationDialog.Help", (String[])new String[0]));
        String docTitle = BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.docTitle", (String[])new String[0]);
        String docHeader = BaseMessages.getString(PKG, (String)"JobExecutionConfigurationDialog.docHeader", (String[])new String[0]);
        this.buttonsSectionLayout(PKG, "JobExecutionConfigurationDialog", docTitle, docUrl, docHeader);
        this.getData();
        this.openDialog();
        return this.retval;
    }

    private String getJobEntryCopyName(JobEntryCopy copy) {
        return copy.getName() + (copy.getNr() > 0 ? Integer.valueOf(copy.getNr()) : "");
    }

    private void getVariablesData() {
        this.wVariables.clearAll(false);
        ArrayList variableNames = new ArrayList(this.configuration.getVariables().keySet());
        Collections.sort(variableNames);
        ArrayList paramNames = new ArrayList(this.configuration.getParams().keySet());
        for (int i = 0; i < variableNames.size(); ++i) {
            String variableName = (String)variableNames.get(i);
            String variableValue = (String)this.configuration.getVariables().get(variableName);
            if (paramNames.contains(variableName)) continue;
            TableItem tableItem = new TableItem(this.wVariables.table, 0);
            tableItem.setText(1, variableName);
            tableItem.setText(2, Const.NVL((String)variableValue, (String)""));
        }
        this.wVariables.removeEmptyRows();
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    public void getData() {
        JobEntryCopy copy;
        this.wExecLocal.setSelection(this.configuration.isExecutingLocally());
        if (this.configuration.isExecutingLocally()) {
            this.stackedLayout.topControl = this.localOptionsComposite;
        }
        this.wExecRemote.setSelection(this.configuration.isExecutingRemotely());
        if (this.configuration.isExecutingRemotely()) {
            this.stackedLayout.topControl = this.serverOptionsComposite;
        }
        this.wSafeMode.setSelection(this.configuration.isSafeModeEnabled());
        this.wClearLog.setSelection(this.configuration.isClearingLog());
        this.wRemoteHost.setText(this.configuration.getRemoteServer() == null ? "" : this.configuration.getRemoteServer().toString());
        this.wPassExport.setSelection(this.configuration.isPassingExport());
        this.wExpandRemote.setSelection(this.getConfiguration().isExpandingRemoteJob());
        this.wLogLevel.select(DefaultLogLevel.getLogLevel().getLevel());
        this.wGatherMetrics.setSelection(this.configuration.isGatheringMetrics());
        String startCopy = "";
        if (!Utils.isEmpty((CharSequence)this.getConfiguration().getStartCopyName()) && (copy = ((JobMeta)this.abstractMeta).findJobEntry(this.getConfiguration().getStartCopyName(), this.getConfiguration().getStartCopyNr(), false)) != null) {
            startCopy = this.getJobEntryCopyName(copy);
        }
        this.wStartCopy.setText(startCopy);
        this.getParamsData();
        this.getVariablesData();
    }

    @Override
    public void getInfo() {
        try {
            this.configuration.setExecutingLocally(this.wExecLocal.getSelection());
            this.configuration.setExecutingRemotely(this.wExecRemote.getSelection());
            if (this.wExecRemote.getSelection()) {
                String serverName = this.wRemoteHost.getText();
                this.configuration.setRemoteServer(this.abstractMeta.findSlaveServer(serverName));
            }
            this.configuration.setPassingExport(this.wPassExport.getSelection());
            this.getConfiguration().setExpandingRemoteJob(this.wExpandRemote.getSelection());
            this.configuration.setReplayDate(null);
            this.configuration.setSafeModeEnabled(this.wSafeMode.getSelection());
            this.configuration.setClearingLog(this.wClearLog.getSelection());
            this.configuration.setLogLevel(LogLevel.values()[this.wLogLevel.getSelectionIndex()]);
            String startCopyName = null;
            int startCopyNr = 0;
            if (!Utils.isEmpty((CharSequence)this.wStartCopy.getText()) && this.wStartCopy.getSelectionIndex() >= 0) {
                JobEntryCopy copy = (JobEntryCopy)((JobMeta)this.abstractMeta).getJobCopies().get(this.wStartCopy.getSelectionIndex());
                startCopyName = copy.getName();
                startCopyNr = copy.getNr();
            }
            this.getConfiguration().setStartCopyName(startCopyName);
            this.getConfiguration().setStartCopyNr(startCopyNr);
            this.getInfoParameters();
            this.getInfoVariables();
            this.configuration.setGatheringMetrics(this.wGatherMetrics.getSelection());
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error in settings", "There is an error in the dialog settings", e);
        }
    }

    public JobExecutionConfiguration getConfiguration() {
        return (JobExecutionConfiguration)this.configuration;
    }
}

