/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;

public class DatabasesCollector {
    private final AbstractMeta meta;
    private final Repository repository;
    private List<String> dbNames;
    private Map<String, DatabaseMeta> names2metas;

    public DatabasesCollector(AbstractMeta meta, Repository repository) {
        this.meta = meta;
        this.repository = repository;
    }

    public void collectDatabases() throws KettleException {
        List dbsFromMeta = this.meta.getDatabases();
        this.names2metas = new HashMap<String, DatabaseMeta>(dbsFromMeta.size());
        for (DatabaseMeta db : dbsFromMeta) {
            this.names2metas.put(db.getName(), db);
        }
        if (this.repository != null) {
            List dbsFromRepo = this.repository.readDatabases();
            for (DatabaseMeta db : dbsFromRepo) {
                if (this.names2metas.containsKey(db.getName())) continue;
                this.names2metas.put(db.getName(), db);
            }
        }
        this.dbNames = new ArrayList<String>(this.names2metas.keySet());
        Collections.sort(this.dbNames, String.CASE_INSENSITIVE_ORDER);
    }

    public List<String> getDatabaseNames() {
        if (this.dbNames == null) {
            throw DatabasesCollector.exception();
        }
        return Collections.unmodifiableList(this.dbNames);
    }

    public DatabaseMeta getMetaFor(String dbName) {
        if (this.names2metas == null) {
            throw DatabasesCollector.exception();
        }
        return this.names2metas.get(dbName);
    }

    private static IllegalStateException exception() {
        return new IllegalStateException("Call collectDatabases() first");
    }
}

