/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.pentaho;

import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfiguration;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;

public class DefaultRunConfigurationExecutor
implements RunConfigurationExecutor {
    private static Class<?> PKG = DefaultRunConfigurationExecutor.class;

    public void execute(RunConfiguration runConfiguration, TransExecutionConfiguration configuration, AbstractMeta meta, VariableSpace variableSpace) throws KettleException {
        DefaultRunConfiguration defaultRunConfiguration = (DefaultRunConfiguration)runConfiguration;
        configuration.setExecutingLocally(defaultRunConfiguration.isLocal());
        configuration.setExecutingRemotely(defaultRunConfiguration.isRemote());
        configuration.setExecutingClustered(defaultRunConfiguration.isClustered());
        if (defaultRunConfiguration.isRemote()) {
            SlaveServer slaveServer = meta.findSlaveServer(defaultRunConfiguration.getServer());
            configuration.setRemoteServer(slaveServer);
            if (slaveServer == null) {
                String filename = "";
                if (variableSpace instanceof TransMeta) {
                    filename = ((TransMeta)variableSpace).getFilename();
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"DefaultRunConfigurationExecutor.RemoteNotFound.Error", (String[])new String[]{filename, runConfiguration.getName(), "{0}", defaultRunConfiguration.getServer()}));
            }
        }
        if (defaultRunConfiguration.isClustered()) {
            configuration.setPassingExport(defaultRunConfiguration.isSendResources());
            configuration.setClusterShowingTransformation(defaultRunConfiguration.isShowTransformations());
            configuration.setClusterPosting(defaultRunConfiguration.isClustered());
            configuration.setClusterPreparing(defaultRunConfiguration.isClustered());
            configuration.setClusterStarting(defaultRunConfiguration.isClustered());
            configuration.setLogRemoteExecutionLocally(defaultRunConfiguration.isLogRemoteExecutionLocally());
        }
        variableSpace.setVariable("engine", null);
        variableSpace.setVariable("engine.remote", null);
    }
}

