/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import org.drools.core.util.ClassUtils;

public class MemoryUtil {
    public static final MemoryStats permGenStats;

    private MemoryUtil() {
    }

    public static boolean hasPermGen() {
        String javaVersion = System.getProperty("java.version");
        return javaVersion.startsWith("1.7") || javaVersion.startsWith("1.6") || javaVersion.startsWith("1.5");
    }

    static {
        if (!MemoryUtil.hasPermGen() || ClassUtils.isAndroid()) {
            permGenStats = new DummyMemoryStats();
        } else {
            MemoryPoolMXBean permGenBean = null;
            for (MemoryPoolMXBean mx : ManagementFactory.getMemoryPoolMXBeans()) {
                if (mx.getName() == null || !mx.getName().contains("Perm")) continue;
                permGenBean = mx;
                break;
            }
            permGenStats = new MBeanMemoryStats(permGenBean);
        }
    }

    public static class MBeanMemoryStats
    implements MemoryStats {
        private final MemoryPoolMXBean memoryBean;

        public MBeanMemoryStats(MemoryPoolMXBean memoryBean) {
            this.memoryBean = memoryBean;
        }

        @Override
        public boolean isUsageThresholdExceeded(int threshold) {
            MemoryUsage memoryUsage = this.getMemoryUsage();
            return memoryUsage != null && memoryUsage.getUsed() * 100L / memoryUsage.getMax() >= (long)threshold;
        }

        public MemoryUsage getMemoryUsage() {
            return this.memoryBean != null ? this.memoryBean.getUsage() : ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        }
    }

    public static class DummyMemoryStats
    implements MemoryStats {
        @Override
        public boolean isUsageThresholdExceeded(int threshold) {
            return false;
        }
    }

    public static interface MemoryStats {
        public boolean isUsageThresholdExceeded(int var1);
    }
}

