/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo;

import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.ui.repo.RepositoryConnectController;
import org.pentaho.di.ui.repo.RepositoryConnectMenu;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPlugin;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulToolbar;

@SpoonPlugin(id="repositories-plugin", image="")
@SpoonPluginCategories(value={"spoon"})
public class RepositorySpoonPlugin
implements SpoonPluginInterface {
    private static final String SPOON_CATEGORY = "spoon";
    private RepositoryConnectController repositoryConnectController;

    public RepositorySpoonPlugin(RepositoryConnectController repositoryConnectController) {
        this.repositoryConnectController = repositoryConnectController;
    }

    public void applyToContainer(String category, XulDomContainer container) throws XulException {
        if (category.equals(SPOON_CATEGORY)) {
            XulToolbar toolbar = (XulToolbar)container.getDocumentRoot().getElementById("main-toolbar");
            RepositoryConnectMenu repoConnectMenu = new RepositoryConnectMenu(Spoon.getInstance(), (ToolBar)toolbar.getManagedObject(), this.repositoryConnectController);
            repoConnectMenu.render();
        }
    }

    public SpoonLifecycleListener getLifecycleListener() {
        return new SpoonLifecycleListener(){

            public void onEvent(SpoonLifecycleListener.SpoonLifeCycleEvent evt) {
                switch (evt) {
                    case REPOSITORY_DISCONNECTED: {
                        RepositorySpoonPlugin.this.repositoryConnectController.fireListeners();
                        break;
                    }
                }
            }
        };
    }

    public SpoonPerspective getPerspective() {
        return null;
    }

    public void removeFromContainer() throws XulException {
    }
}

