/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.util.Arrays;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.MOFIDInfo;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;

public class ShrinkablePage
extends BtreePage {
    private static boolean debug = false;
    private static final byte KEYS_SHRINKED_MASK = 1;
    private static final byte DATA_SHRINKED_MASK = 2;
    static final int KEY_ZERO_PREFIX_LENGTH = 4;
    static final int DATA_ZERO_PREFIX_LENGTH = 4;
    int keyLengthX;
    int dataLengthX;
    boolean keysShrinked;
    boolean dataShrinked;
    boolean keysShrinkable;
    boolean dataShrinkable;
    int currentKeyLength;
    int currentDataLength;
    boolean expandKeys;
    boolean expandData;

    public void init(Btree btree, byte[] pageId, byte[] pageBuffer, boolean isNew) throws StorageException {
        if (this.initialized) {
            return;
        }
        super.init(btree, pageId, pageBuffer, isNew);
        ++this.headerLength;
        this.keyLengthX = btree.keyInfo.getLength();
        this.dataLengthX = btree.dataInfo.getLength();
        this.keysShrinkable = btree.keyInfo instanceof MOFIDInfo;
        this.dataShrinkable = btree.dataInfo instanceof MOFIDInfo;
        if (isNew) {
            this.keysShrinked = this.keysShrinkable;
            this.dataShrinked = this.dataShrinkable;
            ++this.freeStart;
        } else {
            this.keysShrinked = (pageBuffer[this.headerLength - 1] & 1) > 0;
            this.dataShrinked = (pageBuffer[this.headerLength - 1] & 2) > 0;
        }
        this.currentKeyLength = this.keysShrinked ? 4 : this.keyLengthX;
        this.currentDataLength = this.dataShrinked ? 4 : this.dataLengthX;
    }

    int numEntries() {
        return (this.freeStart - this.headerLength) / (this.currentKeyLength + this.currentDataLength);
    }

    int keyOffset(int entryNum) {
        return this.headerLength + entryNum * (this.currentKeyLength + this.currentDataLength);
    }

    int keyLength(int entryNum) {
        return this.keyLengthX;
    }

    byte[] getData(int entryNum) {
        byte[] data = new byte[this.dataLengthX];
        if (this.dataShrinked) {
            System.arraycopy(this.pageBuffer, this.keyOffset(entryNum) + this.currentKeyLength, data, 4, this.currentDataLength);
        } else {
            System.arraycopy(this.pageBuffer, this.keyOffset(entryNum) + this.currentKeyLength, data, 0, this.currentDataLength);
        }
        if (debug) {
            System.out.println("getData called: " + entryNum);
        }
        return data;
    }

    byte[] getKey(int entryNum) {
        byte[] key = new byte[this.keyLengthX];
        if (this.keysShrinked) {
            System.arraycopy(this.pageBuffer, this.keyOffset(entryNum), key, 4, this.currentKeyLength);
        } else {
            System.arraycopy(this.pageBuffer, this.keyOffset(entryNum), key, 0, this.currentKeyLength);
        }
        if (debug) {
            System.out.print("getKey: ");
            int x = 0;
            while (x < key.length) {
                System.out.print(String.valueOf(key[x]) + ":");
                ++x;
            }
            System.out.println("");
        }
        return key;
    }

    protected byte compare(byte[] key, int entryNum) {
        byte k;
        if (!this.isLeaf() && entryNum == 0 && this.pageSource.isNoPage(this.previousPage)) {
            return 1;
        }
        int index = 0;
        if (this.keysShrinkable && this.keysShrinked) {
            while (index < 4) {
                k = key[index];
                if (k < 0) {
                    return -1;
                }
                if (k > 0) {
                    return 1;
                }
                ++index;
            }
        }
        int offset = this.keyOffset(entryNum);
        while (index < key.length) {
            k = key[index];
            byte p = this.pageBuffer[offset];
            if (k < p) {
                return -1;
            }
            if (k > p) {
                return 1;
            }
            ++index;
            ++offset;
        }
        return 0;
    }

    protected byte compareData(byte[] data, int entryNum) {
        byte d;
        int index = 0;
        if (this.dataShrinkable && this.dataShrinked) {
            while (index < 4) {
                d = data[index];
                if (d < 0) {
                    return -1;
                }
                if (d > 0) {
                    return 1;
                }
                ++index;
            }
        }
        int offset = this.keyOffset(entryNum) + this.currentKeyLength;
        while (index < data.length) {
            d = data[index];
            byte p = this.pageBuffer[offset];
            if (d < p) {
                return -1;
            }
            if (d > p) {
                return 1;
            }
            ++index;
            ++offset;
        }
        return 0;
    }

    BtreePage.BtreeEntry insert(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) throws StorageException {
        int x;
        if (debug) {
            System.out.print("insert called: ");
            x = 0;
            while (x < entry.key.length) {
                System.out.print(entry.key[x]);
                ++x;
            }
            System.out.println("");
        }
        if (debug) {
            x = 0;
            while (x < entry.key.length) {
                System.out.print(String.valueOf(entry.key[x]) + ":");
                ++x;
            }
            System.out.print("  ");
            x = 0;
            while (x < entry.data.length) {
                System.out.print(String.valueOf(entry.data[x]) + ":");
                ++x;
            }
            System.out.println();
        }
        int space = 0;
        this.expandKeys = false;
        this.expandData = false;
        this.pageSource.dirtyPage(this);
        if (this.keysShrinked && this.hasLongKey(entry)) {
            this.expandKeys = true;
            space += this.numEntries() * 4 + entry.key.length;
        }
        if (this.dataShrinked && this.hasLongData(entry)) {
            this.expandData = true;
            space += this.numEntries() * 4 + entry.data.length;
        }
        if (!this.expandKeys) {
            space += this.currentKeyLength;
        }
        if (!this.expandData) {
            space += this.currentDataLength;
        }
        if (this.btree.pageSize - this.freeStart - this.keyLengthX - this.dataLengthX >= space) {
            this.insertHere(entry, entryNum, resultPosition);
            return null;
        }
        BtreePage.BtreeEntry result = this.split(entry, entryNum, resultPosition);
        return result;
    }

    BtreePage.BtreeEntry replace(BtreePage.BtreeEntry entry, int entryNum, SearchResult position) throws StorageException {
        if (debug) {
            System.out.println("replace called");
        }
        this.pageSource.dirtyPage(this);
        if (this.dataShrinked && this.hasLongData(entry)) {
            int space = this.numEntries() * (this.currentKeyLength + this.dataLengthX);
            if (this.btree.pageSize - this.freeStart - this.keyLengthX - this.dataLengthX < space) {
                this.delete(entryNum, entryNum);
                return this.insert(entry, entryNum, position);
            }
            this.expandData();
        }
        int offset = this.keyOffset(entryNum) + this.currentKeyLength;
        int dataStart = this.dataShrinked ? 4 : 0;
        System.arraycopy(entry.data, dataStart, this.pageBuffer, offset, this.currentDataLength);
        return null;
    }

    private void insertHere(BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) {
        int offset;
        if (debug) {
            this.dump();
            this.dumpBuffer();
        }
        if (this.expandKeys) {
            this.expandKeys();
        }
        if (this.expandData) {
            this.expandData();
        }
        if ((offset = this.keyOffset(entryNum)) != this.freeStart) {
            System.arraycopy(this.pageBuffer, offset, this.pageBuffer, offset + (this.currentKeyLength + this.currentDataLength), this.freeStart - offset);
        }
        this.copyEntry(offset, entry);
        this.freeStart += this.currentKeyLength + this.currentDataLength;
        if (resultPosition != null) {
            resultPosition.entryNum = entryNum;
            resultPosition.matched = true;
            resultPosition.page = this;
            resultPosition.skipCount = 0;
        }
        if (debug) {
            int x = 0;
            while (x < entry.key.length) {
                System.out.print(entry.key[x]);
                ++x;
            }
            System.out.println("");
            this.dump();
            this.dumpBuffer();
        }
    }

    void delete(int firstEntry, int lastEntry) throws StorageException {
        if (debug) {
            System.out.println("delete called: " + firstEntry + " " + lastEntry);
        }
        this.pageSource.dirtyPage(this);
        int startOffset = this.keyOffset(firstEntry);
        int endOffset = this.keyOffset(lastEntry + 1);
        if (this.freeStart != endOffset) {
            System.arraycopy(this.pageBuffer, endOffset, this.pageBuffer, startOffset, this.freeStart - endOffset);
        }
        this.freeStart -= endOffset - startOffset;
    }

    byte[] splitEntries(BtreePage leftPage, BtreePage rightPage, BtreePage.BtreeEntry entry, int entryNum, SearchResult resultPosition) {
        if (debug) {
            System.out.println("Split entries called.");
        }
        ShrinkablePage left = (ShrinkablePage)leftPage;
        ShrinkablePage right = (ShrinkablePage)rightPage;
        this.copyState(right);
        if (left != this) {
            this.copyState(left);
        }
        int offset = this.keyOffset(entryNum);
        int entryLength = this.currentKeyLength + this.currentDataLength;
        int half = this.numEntries() / 2;
        int midpoint = this.headerLength + half * entryLength;
        boolean insertLeft = offset < midpoint;
        int copyLength = insertLeft ? this.freeStart - midpoint : offset - midpoint;
        if (resultPosition != null) {
            resultPosition.matched = true;
            resultPosition.skipCount = 0;
            if (insertLeft) {
                resultPosition.page = left;
                resultPosition.entryNum = entryNum;
            } else {
                resultPosition.page = right;
                resultPosition.entryNum = entryNum - half;
            }
        }
        if (copyLength > 0) {
            System.arraycopy(this.pageBuffer, midpoint, right.pageBuffer, right.freeStart, copyLength);
            right.freeStart += copyLength;
        }
        if (!insertLeft) {
            right.freeStart += this.currentKeyLength;
            right.freeStart += this.currentDataLength;
            if (this.freeStart != offset) {
                System.arraycopy(this.pageBuffer, offset, right.pageBuffer, right.freeStart, this.freeStart - offset);
                right.freeStart += this.freeStart - offset;
            }
            if (this.expandKeys) {
                right.expandKeys();
            }
            if (this.expandData) {
                right.expandData();
            }
            right.copyEntry(right.keyOffset(entryNum - half), entry);
        }
        if (left != this && (copyLength = insertLeft ? offset - this.headerLength : midpoint - this.headerLength) > 0) {
            System.arraycopy(this.pageBuffer, this.headerLength, left.pageBuffer, left.freeStart, copyLength);
        }
        if (insertLeft) {
            if (midpoint != offset) {
                System.arraycopy(this.pageBuffer, offset, left.pageBuffer, offset + entryLength, midpoint - offset);
            }
            left.freeStart = midpoint + entryLength;
            if (this.expandKeys) {
                left.expandKeys();
            }
            if (this.expandData) {
                left.expandData();
            }
            left.copyEntry(this.keyOffset(entryNum), entry);
        } else {
            left.freeStart = midpoint;
        }
        if (left != this) {
            this.freeStart = this.headerLength;
        }
        return right.getKey(0);
    }

    public void store() {
        super.store();
        int val = 0;
        if (this.keysShrinked) {
            val = (byte)(val + 1);
        }
        if (this.dataShrinked) {
            val = (byte)(val + 2);
        }
        this.pageBuffer[this.headerLength - 1] = val;
    }

    private boolean hasLongKey(BtreePage.BtreeEntry entry) {
        int x = 0;
        while (x < 4) {
            if (entry.key[x] != 0) {
                return true;
            }
            ++x;
        }
        return false;
    }

    private boolean hasLongData(BtreePage.BtreeEntry entry) {
        int x = 0;
        while (x < 4) {
            if (entry.data[x] != 0) {
                return true;
            }
            ++x;
        }
        return false;
    }

    void expandKeys() {
        if (debug) {
            System.out.println("expand keys called");
            this.dump();
        }
        int numEntries = this.numEntries();
        int length = numEntries * (this.currentKeyLength + this.currentDataLength);
        byte[] tempBuffer = new byte[length];
        System.arraycopy(this.pageBuffer, this.headerLength, tempBuffer, 0, length);
        int i = 0;
        while (i < numEntries) {
            int index = this.headerLength + i * (this.keyLengthX + this.currentDataLength);
            Arrays.fill(this.pageBuffer, index, index + 4, (byte)0);
            System.arraycopy(tempBuffer, i * (this.currentKeyLength + this.currentDataLength), this.pageBuffer, 4 + index, this.currentKeyLength + this.currentDataLength);
            ++i;
        }
        this.freeStart += numEntries * 4;
        this.currentKeyLength = this.keyLengthX;
        this.keysShrinked = false;
        if (debug) {
            this.dump();
        }
    }

    void expandData() {
        if (debug) {
            System.out.println("expand data called");
        }
        int numEntries = this.numEntries();
        int length = numEntries * (this.currentKeyLength + this.currentDataLength);
        byte[] tempBuffer = new byte[length];
        System.arraycopy(this.pageBuffer, this.headerLength, tempBuffer, 0, length);
        int i = 0;
        while (i < numEntries) {
            int index = this.headerLength + this.currentKeyLength + i * (this.currentKeyLength + this.dataLengthX);
            System.arraycopy(tempBuffer, i * (this.currentKeyLength + this.currentDataLength), this.pageBuffer, this.headerLength + i * (this.keyLengthX + this.currentDataLength), this.currentKeyLength);
            Arrays.fill(this.pageBuffer, index, index + 4, (byte)0);
            System.arraycopy(tempBuffer, this.currentKeyLength + i * (this.currentKeyLength + this.currentDataLength), this.pageBuffer, this.headerLength + this.currentKeyLength + 4 + i * (this.keyLengthX + this.currentDataLength), this.currentDataLength);
            ++i;
        }
        this.freeStart += numEntries * 4;
        this.currentDataLength = this.dataLengthX;
        this.dataShrinked = false;
    }

    void copyEntry(int offset, BtreePage.BtreeEntry entry) {
        int keyStart = this.keysShrinked ? 4 : 0;
        int dataStart = this.dataShrinked ? 4 : 0;
        System.arraycopy(entry.key, keyStart, this.pageBuffer, offset, this.currentKeyLength);
        System.arraycopy(entry.data, dataStart, this.pageBuffer, offset + this.currentKeyLength, this.currentDataLength);
    }

    private void copyState(ShrinkablePage page) {
        page.keysShrinked = this.keysShrinked;
        page.dataShrinked = this.dataShrinked;
        page.currentKeyLength = this.currentKeyLength;
        page.currentDataLength = this.currentDataLength;
    }

    public void dump() {
        System.out.println("# entries: " + this.numEntries() + " ------------------");
        int i = 0;
        while (i < this.numEntries()) {
            boolean temp = debug;
            debug = true;
            this.getKey(i);
            System.out.print("  ");
            this.getData(i);
            debug = temp;
            ++i;
        }
        System.out.println("----------------------------------");
    }

    public void dumpBuffer() {
        System.out.print("buff: ");
        int x = this.headerLength;
        while (x < this.freeStart) {
            System.out.print(String.valueOf(this.pageBuffer[x]) + ".");
            ++x;
        }
        System.out.println("");
    }
}

