/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import java.io.File;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.pentaho.pdi.spark.driver.Messages;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;

public class CommandLineHandler {
    private String[] args;
    private Options options = new Options();
    private CommandLineParser parser = new BasicParser();
    protected HelpFormatter formatter;

    public CommandLineHandler(String[] args) {
        this.args = args;
        this.options.addOption("h", "help", false, Messages.getString("HELP.helpDesc"));
        this.options.addOption("p", "pdiLocation", true, Messages.getString("HELP.pdiLocationDesc"));
        this.options.addOption("o", "outputLocation", true, Messages.getString("HELP.outputLocationDesc"));
        Option pluginExcludes = new Option("e", "exclude-plugins", true, Messages.getString("HELP.pluginExcludeDesc"));
        pluginExcludes.setArgs(-2);
        this.options.addOption(pluginExcludes);
        Option excludes = new Option("x", "exclude", true, Messages.getString("HELP.excludeDesc"));
        excludes.setArgs(-2);
        this.options.addOption(excludes);
    }

    public AppBuilderContext parse() {
        try {
            String[] excludedPlugins;
            String[] excludedValues;
            CommandLine cmd = this.parser.parse(this.options, this.args);
            AppBuilderContext context = new AppBuilderContext();
            if (cmd.hasOption("h")) {
                this.help();
                return null;
            }
            if (cmd.hasOption("p")) {
                context.setPdiLocation(new File(cmd.getOptionValue("p")));
            }
            if (cmd.hasOption("o")) {
                context.setOutputLocation(new File(cmd.getOptionValue("o")));
            }
            if (cmd.hasOption("x") && (excludedValues = cmd.getOptionValues("x")) != null) {
                context.exclude(excludedValues);
            }
            if (cmd.hasOption("e") && (excludedPlugins = cmd.getOptionValues("e")) != null) {
                context.excludePlugin(excludedPlugins);
            }
            context.validate();
            return context;
        }
        catch (Exception e) {
            System.err.println(Messages.getString("ERROR.generic", e.getMessage()));
            this.help();
            return null;
        }
    }

    public void help() {
        if (this.formatter == null) {
            this.formatter = new HelpFormatter();
        }
        this.formatter.setWidth(120);
        this.formatter.setNewLine("\n");
        this.formatter.printHelp("SparkAppDriverBuilder [-h] [-p <path>] [-o <path>] [-e <plugin1> ... <pluginN>] [-x <pattern1> ... <patternN>]", this.options);
    }
}

