/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_BUNDLE_JOB", query="update BundleJobBean w set w.appName = :appName, w.appPath = :appPath, w.conf = :conf, w.externalId = :externalId, w.timeOut = :timeOut, w.createdTimestamp = :createdTime, w.endTimestamp = :endTime, w.jobXml = :jobXml, w.lastModifiedTimestamp = :lastModifiedTime, w.origJobXml = :origJobXml, w.startTimestamp = :startTime, w.statusStr = :status, w.timeUnitStr = :timeUnit, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_STATUS", query="update BundleJobBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_STATUS_PENDING", query="update BundleJobBean w set w.statusStr = :status, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_STATUS_PENDING_MODTIME", query="update BundleJobBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_STATUS_PENDING_SUSP_MOD_TIME", query="update BundleJobBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending, w.suspendedTimestamp = :suspendedTime where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_STATUS_PAUSE_ENDTIME", query="update BundleJobBean w set w.statusStr = :status, w.pauseTimestamp = :pauseTime, w.endTimestamp = :endTime where w.id = :id"), @NamedQuery(name="UPDATE_BUNDLE_JOB_PAUSE_KICKOFF", query="update BundleJobBean w set w.kickoffTimestamp = :kickoffTime, w.pauseTimestamp = :pauseTime where w.id = :id"), @NamedQuery(name="DELETE_BUNDLE_JOB", query="delete from BundleJobBean w where w.id IN (:id)"), @NamedQuery(name="GET_BUNDLE_JOBS", query="select OBJECT(w) from BundleJobBean w"), @NamedQuery(name="GET_BUNDLE_JOB", query="select OBJECT(w) from BundleJobBean w where w.id = :id"), @NamedQuery(name="GET_BUNDLE_JOB_STATUS", query="select w.statusStr from BundleJobBean w where w.id = :id"), @NamedQuery(name="GET_BUNDLE_JOB_ID_STATUS_PENDING_MODTIME", query="select w.id, w.statusStr, w.pending, w.lastModifiedTimestamp from BundleJobBean w where w.id = :id"), @NamedQuery(name="GET_BUNDLE_JOB_ID_JOBXML_CONF", query="select w.id, w.jobXml, w.conf from BundleJobBean w where w.id = :id"), @NamedQuery(name="GET_BUNDLE_JOBS_COUNT", query="select count(w) from BundleJobBean w"), @NamedQuery(name="GET_BUNDLE_JOBS_COLUMNS", query="select w.id, w.appName, w.appPath, w.conf, w.statusStr, w.kickoffTimestamp, w.startTimestamp, w.endTimestamp, w.pauseTimestamp, w.createdTimestamp, w.user, w.group, w.timeUnitStr, w.timeOut from BundleJobBean w order by w.createdTimestamp desc"), @NamedQuery(name="GET_BUNDLE_JOBS_RUNNING_OR_PENDING", query="select OBJECT(w) from BundleJobBean w where w.statusStr = 'RUNNING' OR w.statusStr = 'RUNNINGWITHERROR' OR w.pending = 1 order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_NEED_START", query="select OBJECT(w) from BundleJobBean w where w.statusStr = 'PREP' AND (w.kickoffTimestamp IS NULL OR (w.kickoffTimestamp IS NOT NULL AND w.kickoffTimestamp <= :currentTime)) order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_PAUSED", query="select OBJECT(w) from BundleJobBean w where w.statusStr = 'PAUSED' OR w.statusStr = 'PAUSEDWITHERROR' OR w.statusStr = 'PREPPAUSED' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_UNPAUSED", query="select OBJECT(w) from BundleJobBean w where w.statusStr = 'RUNNING' OR w.statusStr = 'RUNNINGWITHERROR' OR w.statusStr = 'PREP' order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_OLDER_THAN", query="select OBJECT(w) from BundleJobBean w where w.startTimestamp <= :matTime AND (w.statusStr = 'PREP' OR w.statusStr = 'RUNNING' or w.statusStr = 'RUNNINGWITHERROR')  order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_BUNDLE_JOBS_OLDER_THAN_STATUS", query="select OBJECT(w) from BundleJobBean w where w.statusStr = :status AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="GET_COMPLETED_BUNDLE_JOBS_OLDER_THAN", query="select w.id from BundleJobBean w where ( w.statusStr = 'SUCCEEDED' OR w.statusStr = 'FAILED' OR w.statusStr = 'KILLED' OR w.statusStr = 'DONEWITHERROR') AND w.lastModifiedTimestamp <= :lastModTime order by w.lastModifiedTimestamp"), @NamedQuery(name="BULK_MONITOR_BUNDLE_QUERY", query="SELECT b.id, b.appName, b.statusStr, b.user FROM BundleJobBean b"), @NamedQuery(name="BULK_MONITOR_ACTIONS_QUERY", query="SELECT a.id, a.actionNumber, a.errorCode, a.errorMessage, a.externalId, a.externalStatus, a.statusStr, a.createdTimestamp, a.nominalTimestamp, a.missingDependencies, c.id, c.appName, c.statusStr FROM CoordinatorActionBean a, CoordinatorJobBean c WHERE a.jobId = c.id AND c.bundleId = :bundleId ORDER BY a.jobId, a.createdTimestamp"), @NamedQuery(name="BULK_MONITOR_COUNT_QUERY", query="SELECT COUNT(a) FROM CoordinatorActionBean a, CoordinatorJobBean c"), @NamedQuery(name="GET_BUNDLE_IDS_FOR_STATUS_TRANSIT", query="select DISTINCT w.id from BundleActionBean a , BundleJobBean w where a.lastModifiedTimestamp >= :lastModifiedTime and w.id = a.bundleId and (w.statusStr = 'RUNNING' OR w.statusStr = 'RUNNINGWITHERROR' OR w.statusStr = 'PAUSED' OR w.statusStr = 'PAUSEDWITHERROR' OR w.pending = 1)"), @NamedQuery(name="GET_BUNDLE_JOB_FOR_USER", query="select w.user from BundleJobBean w where w.id = :id")})
@Table(name="BUNDLE_JOBS")
public class BundleJobBean
implements Writable,
BundleJob,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="app_path")
    private String appPath = null;
    @Basic
    @Column(name="app_name")
    private String appName = null;
    @Basic
    @Column(name="external_id")
    private String externalId = null;
    @Basic
    @Column(name="conf")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob conf;
    @Basic
    @Column(name="time_out")
    private int timeOut = 0;
    @Basic
    @Column(name="user_name")
    private String user = null;
    @Basic
    @Column(name="group_name")
    private String group = null;
    @Transient
    private String consoleUrl;
    @Basic
    @Index
    @Column(name="status")
    private String statusStr = Job.Status.PREP.toString();
    @Basic
    @Column(name="kickoff_time")
    private Timestamp kickoffTimestamp = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Basic
    @Column(name="pause_time")
    private Timestamp pauseTimestamp = null;
    @Basic
    @Index
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Column(name="time_unit")
    private String timeUnitStr = BundleJob.Timeunit.NONE.toString();
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Basic
    @Index
    @Column(name="suspended_time")
    private Timestamp suspendedTimestamp = null;
    @Basic
    @Column(name="job_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob jobXml;
    @Basic
    @Column(name="orig_job_xml")
    @Lob
    @Strategy(value="org.apache.oozie.executor.jpa.StringBlobValueHandler")
    private StringBlob origJobXml = null;
    @Transient
    private List<CoordinatorJobBean> coordJobs = new ArrayList<CoordinatorJobBean>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$StringBlob;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$BundleJobBean;
    private transient Object pcDetachedState;

    public Timestamp getKickoffTimestamp() {
        return BundleJobBean.pcGetkickoffTimestamp(this);
    }

    public Timestamp getstartTimestamp() {
        return BundleJobBean.pcGetstartTimestamp(this);
    }

    public void setKickoffTimestamp(Timestamp kickoffTimestamp) {
        BundleJobBean.pcSetkickoffTimestamp(this, kickoffTimestamp);
    }

    public void setStartTimestamp(Timestamp startTimestamp) {
        BundleJobBean.pcSetstartTimestamp(this, startTimestamp);
    }

    public void setStartTime(Date startTime) {
        BundleJobBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    public Timestamp getEndTimestamp() {
        return BundleJobBean.pcGetendTimestamp(this);
    }

    public void setEndTimestamp(Timestamp endTimestamp) {
        BundleJobBean.pcSetendTimestamp(this, endTimestamp);
    }

    public Timestamp getPauseTimestamp() {
        return BundleJobBean.pcGetpauseTimestamp(this);
    }

    public void setPauseTimestamp(Timestamp pauseTimestamp) {
        BundleJobBean.pcSetpauseTimestamp(this, pauseTimestamp);
    }

    public Timestamp getCreatedTimestamp() {
        return BundleJobBean.pcGetcreatedTimestamp(this);
    }

    public Date getCreatedTime() {
        return DateUtils.toDate(BundleJobBean.pcGetcreatedTimestamp(this));
    }

    public String getTimeUnitStr() {
        return BundleJobBean.pcGettimeUnitStr(this);
    }

    public int getPending() {
        return BundleJobBean.pcGetpending(this);
    }

    public void setPending() {
        BundleJobBean.pcSetpending(this, 1);
    }

    public void setPending(int i) {
        BundleJobBean.pcSetpending(this, i);
    }

    public void resetPending() {
        BundleJobBean.pcSetpending(this, 0);
    }

    public boolean isPending() {
        return BundleJobBean.pcGetpending(this) == 1;
    }

    public Timestamp getLastModifiedTimestamp() {
        return BundleJobBean.pcGetlastModifiedTimestamp(this);
    }

    public void setLastModifiedTimestamp(Timestamp lastModifiedTimestamp) {
        BundleJobBean.pcSetlastModifiedTimestamp(this, lastModifiedTimestamp);
    }

    public Timestamp getSuspendedTimestamp() {
        return BundleJobBean.pcGetsuspendedTimestamp(this);
    }

    public void setSuspendedTimestamp(Timestamp suspendedTimestamp) {
        BundleJobBean.pcSetsuspendedTimestamp(this, suspendedTimestamp);
    }

    public String getJobXml() {
        return BundleJobBean.pcGetjobXml(this) == null ? null : BundleJobBean.pcGetjobXml(this).getString();
    }

    public void setJobXml(String jobXml) {
        if (BundleJobBean.pcGetjobXml(this) == null) {
            BundleJobBean.pcSetjobXml(this, new StringBlob(jobXml));
        } else {
            BundleJobBean.pcGetjobXml(this).setString(jobXml);
        }
    }

    public void setJobXmlBlob(StringBlob jobXmlBlob) {
        BundleJobBean.pcSetjobXml(this, jobXmlBlob);
    }

    public StringBlob getJobXmlBlob() {
        return BundleJobBean.pcGetjobXml(this);
    }

    public String getOrigJobXml() {
        return BundleJobBean.pcGetorigJobXml(this) == null ? null : BundleJobBean.pcGetorigJobXml(this).getString();
    }

    public void setOrigJobXml(String origJobXml) {
        if (BundleJobBean.pcGetorigJobXml(this) == null) {
            BundleJobBean.pcSetorigJobXml(this, new StringBlob(origJobXml));
        } else {
            BundleJobBean.pcGetorigJobXml(this).setString(origJobXml);
        }
    }

    public void setOrigJobXmlBlob(StringBlob origJobXml) {
        BundleJobBean.pcSetorigJobXml(this, origJobXml);
    }

    public StringBlob getOrigJobXmlBlob() {
        return BundleJobBean.pcGetorigJobXml(this);
    }

    public void setCreatedTime(Date createTime) {
        BundleJobBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createTime));
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        BundleJobBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(BundleJobBean.pcGetlastModifiedTimestamp(this));
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getAppPath());
        WritableUtils.writeStr(dataOutput, this.getAppName());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        WritableUtils.writeStr(dataOutput, this.getTimeUnit().toString());
        dataOutput.writeLong(this.getKickoffTime() != null ? this.getKickoffTime().getTime() : -1L);
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getUser());
        WritableUtils.writeStr(dataOutput, this.getGroup());
        WritableUtils.writeStr(dataOutput, this.getExternalId());
        dataOutput.writeInt(this.getTimeout());
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setAppPath(WritableUtils.readStr(dataInput));
        this.setAppName(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(Job.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        this.setTimeUnit(BundleJob.Timeunit.valueOf((String)WritableUtils.readStr(dataInput)));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setKickoffTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setStartTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        this.setUser(WritableUtils.readStr(dataInput));
        this.setGroup(WritableUtils.readStr(dataInput));
        this.setExternalId(WritableUtils.readStr(dataInput));
        this.setTimeOut(dataInput.readInt());
    }

    public Date getEndTime() {
        return DateUtils.toDate(BundleJobBean.pcGetendTimestamp(this));
    }

    public Date getKickoffTime() {
        return DateUtils.toDate(BundleJobBean.pcGetkickoffTimestamp(this));
    }

    public BundleJob.Timeunit getTimeUnit() {
        return BundleJob.Timeunit.valueOf((String)BundleJobBean.pcGettimeUnitStr(this));
    }

    public void setEndTime(Date endTime) {
        BundleJobBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    public void setKickoffTime(Date kickoffTime) {
        BundleJobBean.pcSetkickoffTimestamp(this, DateUtils.convertDateToTimestamp(kickoffTime));
    }

    public Date getPauseTime() {
        return DateUtils.toDate(BundleJobBean.pcGetpauseTimestamp(this));
    }

    public void setPauseTime(Date pauseTime) {
        BundleJobBean.pcSetpauseTimestamp(this, DateUtils.convertDateToTimestamp(pauseTime));
    }

    public void setSuspendedTime(Date suspendTime) {
        BundleJobBean.pcSetsuspendedTimestamp(this, DateUtils.convertDateToTimestamp(suspendTime));
    }

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"bundleJobPath", (Object)BundleJobBean.pcGetappPath(this));
        json.put((Object)"bundleJobName", (Object)BundleJobBean.pcGetappName(this));
        json.put((Object)"bundleJobId", (Object)BundleJobBean.pcGetid(this));
        json.put((Object)"bundleExternalId", (Object)BundleJobBean.pcGetexternalId(this));
        json.put((Object)"conf", (Object)this.getConf());
        json.put((Object)"status", (Object)this.getStatus().toString());
        json.put((Object)"timeUnit", (Object)this.getTimeUnit().toString());
        json.put((Object)"timeOut", (Object)BundleJobBean.pcGettimeOut(this));
        json.put((Object)"kickoffTime", (Object)JsonUtils.formatDateRfc822((Date)this.getKickoffTime(), (String)timeZoneId));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"pauseTime", (Object)JsonUtils.formatDateRfc822((Date)this.getPauseTime(), (String)timeZoneId));
        json.put((Object)"createdTime", (Object)JsonUtils.formatDateRfc822((Date)this.getCreatedTime(), (String)timeZoneId));
        json.put((Object)"user", (Object)this.getUser());
        json.put((Object)"group", (Object)this.getGroup());
        json.put((Object)"acl", (Object)this.getAcl());
        json.put((Object)"consoleUrl", (Object)this.getConsoleUrl());
        json.put((Object)"bundleCoordJobs", (Object)CoordinatorJobBean.toJSONArray(this.coordJobs, timeZoneId));
        json.put((Object)"toString", (Object)this.toString());
        return json;
    }

    public String getAppName() {
        return BundleJobBean.pcGetappName(this);
    }

    public String getAppPath() {
        return BundleJobBean.pcGetappPath(this);
    }

    public String getConf() {
        return BundleJobBean.pcGetconf(this) == null ? null : BundleJobBean.pcGetconf(this).getString();
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public List<CoordinatorJob> getCoordinators() {
        return this.coordJobs;
    }

    @Deprecated
    public String getGroup() {
        return BundleJobBean.pcGetgroup(this);
    }

    public String getAcl() {
        return this.getGroup();
    }

    public String getId() {
        return BundleJobBean.pcGetid(this);
    }

    public int getTimeout() {
        return BundleJobBean.pcGettimeOut(this);
    }

    public String getUser() {
        return BundleJobBean.pcGetuser(this);
    }

    public void setId(String id) {
        BundleJobBean.pcSetid(this, id);
    }

    public void setAppPath(String bundlePath) {
        BundleJobBean.pcSetappPath(this, bundlePath);
    }

    public void setAppName(String bundleName) {
        BundleJobBean.pcSetappName(this, bundleName);
    }

    public String getExternalId() {
        return BundleJobBean.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        BundleJobBean.pcSetexternalId(this, externalId);
    }

    public void setConf(String conf) {
        if (BundleJobBean.pcGetconf(this) == null) {
            BundleJobBean.pcSetconf(this, new StringBlob(conf));
        } else {
            BundleJobBean.pcGetconf(this).setString(conf);
        }
    }

    public void setConfBlob(StringBlob conf) {
        BundleJobBean.pcSetconf(this, conf);
    }

    public StringBlob getConfBlob() {
        return BundleJobBean.pcGetconf(this);
    }

    public void setStatus(Job.Status status) {
        BundleJobBean.pcSetstatusStr(this, status.toString());
    }

    public Job.Status getStatus() {
        return Job.Status.valueOf((String)BundleJobBean.pcGetstatusStr(this));
    }

    public void setStatus(String statusStr) {
        BundleJobBean.pcSetstatusStr(this, statusStr);
    }

    public String getStatusStr() {
        return BundleJobBean.pcGetstatusStr(this);
    }

    public void setTimeUnit(BundleJob.Timeunit timeUnit) {
        BundleJobBean.pcSettimeUnitStr(this, timeUnit.toString());
    }

    public void setTimeOut(int timeOut) {
        BundleJobBean.pcSettimeOut(this, timeOut);
    }

    public void setUser(String user) {
        BundleJobBean.pcSetuser(this, user);
    }

    public void setGroup(String group) {
        BundleJobBean.pcSetgroup(this, group);
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public void setCoordJobs(List<CoordinatorJobBean> coordJobs) {
        this.coordJobs = coordJobs != null ? coordJobs : new ArrayList();
    }

    public static JSONArray toJSONArray(List<BundleJobBean> applications, String timeZoneId) {
        JSONArray array = new JSONArray();
        if (applications != null) {
            for (BundleJobBean application : applications) {
                array.add((Object)application.toJSONObject(timeZoneId));
            }
        }
        return array;
    }

    public String toString() {
        return MessageFormat.format("Bundle id[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public Date getStartTime() {
        return DateUtils.toDate(BundleJobBean.pcGetstartTimestamp(this));
    }

    public boolean isTerminalStatus() {
        boolean isTerminal = false;
        switch (this.getStatus()) {
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: 
            case DONEWITHERROR: {
                isTerminal = true;
                break;
            }
            default: {
                isTerminal = false;
            }
        }
        return isTerminal;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"appName", "appPath", "conf", "createdTimestamp", "endTimestamp", "externalId", "group", "id", "jobXml", "kickoffTimestamp", "lastModifiedTimestamp", "origJobXml", "pauseTimestamp", "pending", "startTimestamp", "statusStr", "suspendedTimestamp", "timeOut", "timeUnitStr", "user"};
        Class[] classArray = new Class[20];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        Class clazz2 = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = BundleJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[2] = clazz2;
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[3] = clazz3;
        classArray[4] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[8] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = BundleJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[9] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[10] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[11] = class$Lorg$apache$oozie$StringBlob != null ? class$Lorg$apache$oozie$StringBlob : (class$Lorg$apache$oozie$StringBlob = BundleJobBean.class$("org.apache.oozie.StringBlob"));
        classArray[12] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[13] = Integer.TYPE;
        classArray[14] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[16] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleJobBean.class$("java.sql.Timestamp"));
        classArray[17] = Integer.TYPE;
        classArray[18] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        classArray[19] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleJobBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 26, 26, 26, 26, 10, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$oozie$BundleJobBean != null ? class$Lorg$apache$oozie$BundleJobBean : (class$Lorg$apache$oozie$BundleJobBean = BundleJobBean.class$("org.apache.oozie.BundleJobBean"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"BundleJobBean", (PersistenceCapable)new BundleJobBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.appName = null;
        this.appPath = null;
        this.conf = null;
        this.createdTimestamp = null;
        this.endTimestamp = null;
        this.externalId = null;
        this.group = null;
        this.id = null;
        this.jobXml = null;
        this.kickoffTimestamp = null;
        this.lastModifiedTimestamp = null;
        this.origJobXml = null;
        this.pauseTimestamp = null;
        this.pending = 0;
        this.startTimestamp = null;
        this.statusStr = null;
        this.suspendedTimestamp = null;
        this.timeOut = 0;
        this.timeUnitStr = null;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        BundleJobBean bundleJobBean = new BundleJobBean();
        if (bl) {
            bundleJobBean.pcClearFields();
        }
        bundleJobBean.pcStateManager = stateManager;
        bundleJobBean.pcCopyKeyFieldsFromObjectId(object);
        return bundleJobBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        BundleJobBean bundleJobBean = new BundleJobBean();
        if (bl) {
            bundleJobBean.pcClearFields();
        }
        bundleJobBean.pcStateManager = stateManager;
        return bundleJobBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 20;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.appPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.conf = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.group = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.jobXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.kickoffTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.origJobXml = (StringBlob)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.pauseTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.statusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.suspendedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.timeOut = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.timeUnitStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appPath);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.conf);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.group);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.jobXml);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.kickoffTimestamp);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.origJobXml);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pauseTimestamp);
                return;
            }
            case 13: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.statusStr);
                return;
            }
            case 16: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.suspendedTimestamp);
                return;
            }
            case 17: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.timeOut);
                return;
            }
            case 18: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeUnitStr);
                return;
            }
            case 19: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(BundleJobBean bundleJobBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = bundleJobBean.appName;
                return;
            }
            case 1: {
                this.appPath = bundleJobBean.appPath;
                return;
            }
            case 2: {
                this.conf = bundleJobBean.conf;
                return;
            }
            case 3: {
                this.createdTimestamp = bundleJobBean.createdTimestamp;
                return;
            }
            case 4: {
                this.endTimestamp = bundleJobBean.endTimestamp;
                return;
            }
            case 5: {
                this.externalId = bundleJobBean.externalId;
                return;
            }
            case 6: {
                this.group = bundleJobBean.group;
                return;
            }
            case 7: {
                this.id = bundleJobBean.id;
                return;
            }
            case 8: {
                this.jobXml = bundleJobBean.jobXml;
                return;
            }
            case 9: {
                this.kickoffTimestamp = bundleJobBean.kickoffTimestamp;
                return;
            }
            case 10: {
                this.lastModifiedTimestamp = bundleJobBean.lastModifiedTimestamp;
                return;
            }
            case 11: {
                this.origJobXml = bundleJobBean.origJobXml;
                return;
            }
            case 12: {
                this.pauseTimestamp = bundleJobBean.pauseTimestamp;
                return;
            }
            case 13: {
                this.pending = bundleJobBean.pending;
                return;
            }
            case 14: {
                this.startTimestamp = bundleJobBean.startTimestamp;
                return;
            }
            case 15: {
                this.statusStr = bundleJobBean.statusStr;
                return;
            }
            case 16: {
                this.suspendedTimestamp = bundleJobBean.suspendedTimestamp;
                return;
            }
            case 17: {
                this.timeOut = bundleJobBean.timeOut;
                return;
            }
            case 18: {
                this.timeUnitStr = bundleJobBean.timeUnitStr;
                return;
            }
            case 19: {
                this.user = bundleJobBean.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        BundleJobBean bundleJobBean = (BundleJobBean)object;
        if (bundleJobBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(bundleJobBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(7 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$BundleJobBean != null ? class$Lorg$apache$oozie$BundleJobBean : (class$Lorg$apache$oozie$BundleJobBean = BundleJobBean.class$("org.apache.oozie.BundleJobBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$BundleJobBean != null ? class$Lorg$apache$oozie$BundleJobBean : (class$Lorg$apache$oozie$BundleJobBean = BundleJobBean.class$("org.apache.oozie.BundleJobBean"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetappName(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.appName;
        }
        int n = pcInheritedFieldCount + 0;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.appName;
    }

    private static final void pcSetappName(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.appName = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 0, bundleJobBean.appName, string, 0);
    }

    private static final String pcGetappPath(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.appPath;
        }
        int n = pcInheritedFieldCount + 1;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.appPath;
    }

    private static final void pcSetappPath(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.appPath = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 1, bundleJobBean.appPath, string, 0);
    }

    private static final StringBlob pcGetconf(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.conf;
        }
        int n = pcInheritedFieldCount + 2;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.conf;
    }

    private static final void pcSetconf(BundleJobBean bundleJobBean, StringBlob stringBlob) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.conf = stringBlob;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 2, (Object)bundleJobBean.conf, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetcreatedTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 3;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.createdTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 3, (Object)bundleJobBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetendTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.endTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 4, (Object)bundleJobBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexternalId(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.externalId;
        }
        int n = pcInheritedFieldCount + 5;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.externalId;
    }

    private static final void pcSetexternalId(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.externalId = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 5, bundleJobBean.externalId, string, 0);
    }

    private static final String pcGetgroup(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.group;
        }
        int n = pcInheritedFieldCount + 6;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.group;
    }

    private static final void pcSetgroup(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.group = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 6, bundleJobBean.group, string, 0);
    }

    private static final String pcGetid(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.id;
        }
        int n = pcInheritedFieldCount + 7;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.id;
    }

    private static final void pcSetid(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.id = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 7, bundleJobBean.id, string, 0);
    }

    private static final StringBlob pcGetjobXml(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.jobXml;
        }
        int n = pcInheritedFieldCount + 8;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.jobXml;
    }

    private static final void pcSetjobXml(BundleJobBean bundleJobBean, StringBlob stringBlob) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.jobXml = stringBlob;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 8, (Object)bundleJobBean.jobXml, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetkickoffTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.kickoffTimestamp;
        }
        int n = pcInheritedFieldCount + 9;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.kickoffTimestamp;
    }

    private static final void pcSetkickoffTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.kickoffTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 9, (Object)bundleJobBean.kickoffTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 10;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.lastModifiedTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 10, (Object)bundleJobBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final StringBlob pcGetorigJobXml(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.origJobXml;
        }
        int n = pcInheritedFieldCount + 11;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.origJobXml;
    }

    private static final void pcSetorigJobXml(BundleJobBean bundleJobBean, StringBlob stringBlob) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.origJobXml = stringBlob;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 11, (Object)bundleJobBean.origJobXml, (Object)stringBlob, 0);
    }

    private static final Timestamp pcGetpauseTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.pauseTimestamp;
        }
        int n = pcInheritedFieldCount + 12;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.pauseTimestamp;
    }

    private static final void pcSetpauseTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.pauseTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 12, (Object)bundleJobBean.pauseTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.pending;
        }
        int n = pcInheritedFieldCount + 13;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.pending;
    }

    private static final void pcSetpending(BundleJobBean bundleJobBean, int n) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.pending = n;
            return;
        }
        bundleJobBean.pcStateManager.settingIntField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 13, bundleJobBean.pending, n, 0);
    }

    private static final Timestamp pcGetstartTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 14;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.startTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 14, (Object)bundleJobBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatusStr(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.statusStr;
        }
        int n = pcInheritedFieldCount + 15;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.statusStr;
    }

    private static final void pcSetstatusStr(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.statusStr = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 15, bundleJobBean.statusStr, string, 0);
    }

    private static final Timestamp pcGetsuspendedTimestamp(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.suspendedTimestamp;
        }
        int n = pcInheritedFieldCount + 16;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.suspendedTimestamp;
    }

    private static final void pcSetsuspendedTimestamp(BundleJobBean bundleJobBean, Timestamp timestamp) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.suspendedTimestamp = timestamp;
            return;
        }
        bundleJobBean.pcStateManager.settingObjectField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 16, (Object)bundleJobBean.suspendedTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGettimeOut(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.timeOut;
        }
        int n = pcInheritedFieldCount + 17;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.timeOut;
    }

    private static final void pcSettimeOut(BundleJobBean bundleJobBean, int n) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.timeOut = n;
            return;
        }
        bundleJobBean.pcStateManager.settingIntField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 17, bundleJobBean.timeOut, n, 0);
    }

    private static final String pcGettimeUnitStr(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.timeUnitStr;
        }
        int n = pcInheritedFieldCount + 18;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.timeUnitStr;
    }

    private static final void pcSettimeUnitStr(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.timeUnitStr = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 18, bundleJobBean.timeUnitStr, string, 0);
    }

    private static final String pcGetuser(BundleJobBean bundleJobBean) {
        if (bundleJobBean.pcStateManager == null) {
            return bundleJobBean.user;
        }
        int n = pcInheritedFieldCount + 19;
        bundleJobBean.pcStateManager.accessingField(n);
        return bundleJobBean.user;
    }

    private static final void pcSetuser(BundleJobBean bundleJobBean, String string) {
        if (bundleJobBean.pcStateManager == null) {
            bundleJobBean.user = string;
            return;
        }
        bundleJobBean.pcStateManager.settingStringField((PersistenceCapable)bundleJobBean, pcInheritedFieldCount + 19, bundleJobBean.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

