/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.rsa.discovery.local.EndpointDescriptionBundleParser;
import org.apache.aries.rsa.util.StringPlus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;

public class LocalDiscovery
implements BundleListener {
    Map<EndpointDescription, Bundle> endpointDescriptions = new ConcurrentHashMap<EndpointDescription, Bundle>();
    Map<EndpointListener, Collection<String>> listenerToFilters = new HashMap<EndpointListener, Collection<String>>();
    Map<String, Collection<EndpointListener>> filterToListeners = new HashMap<String, Collection<EndpointListener>>();
    EndpointDescriptionBundleParser bundleParser = new EndpointDescriptionBundleParser();

    public void processExistingBundles(Bundle[] bundles) {
        if (bundles == null) {
            return;
        }
        for (Bundle b : bundles) {
            if (b.getState() != 32) continue;
            this.findDeclaredRemoteServices(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ServiceReference<EndpointListener> endpointListenerRef, EndpointListener endpointListener) {
        List filters = StringPlus.normalize((Object)endpointListenerRef.getProperty("endpoint.listener.scope"));
        if (filters.isEmpty()) {
            return;
        }
        Map<EndpointListener, Collection<String>> map = this.listenerToFilters;
        synchronized (map) {
            this.listenerToFilters.put(endpointListener, filters);
            for (String filter : filters) {
                Collection<EndpointListener> listeners = this.filterToListeners.get(filter);
                if (listeners == null) {
                    listeners = new ArrayList<EndpointListener>();
                    this.filterToListeners.put(filter, listeners);
                }
                listeners.add(endpointListener);
            }
        }
        this.triggerCallbacks(filters, endpointListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(EndpointListener endpointListener) {
        Map<EndpointListener, Collection<String>> map = this.listenerToFilters;
        synchronized (map) {
            Collection<String> filters = this.listenerToFilters.remove(endpointListener);
            if (filters == null) {
                return;
            }
            for (String filter : filters) {
                Collection<EndpointListener> listeners = this.filterToListeners.get(filter);
                if (listeners == null) continue;
                listeners.remove(endpointListener);
                if (!listeners.isEmpty()) continue;
                this.filterToListeners.remove(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<EndpointListener>> getMatchingListeners(EndpointDescription endpoint) {
        HashMap<String, Collection<EndpointListener>> matched = new HashMap<String, Collection<EndpointListener>>();
        Map<EndpointListener, Collection<String>> map = this.listenerToFilters;
        synchronized (map) {
            for (Map.Entry<String, Collection<EndpointListener>> entry : this.filterToListeners.entrySet()) {
                String filter = entry.getKey();
                if (!LocalDiscovery.matchFilter(filter, endpoint)) continue;
                matched.put(filter, new ArrayList<EndpointListener>(entry.getValue()));
            }
        }
        return matched;
    }

    public void bundleChanged(BundleEvent be) {
        switch (be.getType()) {
            case 2: {
                this.findDeclaredRemoteServices(be.getBundle());
                break;
            }
            case 4: {
                this.removeServicesDeclaredInBundle(be.getBundle());
                break;
            }
        }
    }

    private void findDeclaredRemoteServices(Bundle bundle) {
        List<EndpointDescription> endpoints = this.bundleParser.getAllEndpointDescriptions(bundle);
        for (EndpointDescription endpoint : endpoints) {
            this.endpointDescriptions.put(endpoint, bundle);
            this.addedEndpointDescription(endpoint);
        }
    }

    private void removeServicesDeclaredInBundle(Bundle bundle) {
        Iterator<Map.Entry<EndpointDescription, Bundle>> i = this.endpointDescriptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<EndpointDescription, Bundle> entry = i.next();
            if (!bundle.equals(entry.getValue())) continue;
            this.removedEndpointDescription(entry.getKey());
            i.remove();
        }
    }

    private void addedEndpointDescription(EndpointDescription endpoint) {
        this.triggerCallbacks(endpoint, true);
    }

    private void removedEndpointDescription(EndpointDescription endpoint) {
        this.triggerCallbacks(endpoint, false);
    }

    private void triggerCallbacks(EndpointDescription endpoint, boolean added) {
        for (Map.Entry<String, Collection<EndpointListener>> entry : this.getMatchingListeners(endpoint).entrySet()) {
            String filter = entry.getKey();
            for (EndpointListener listener : entry.getValue()) {
                this.triggerCallbacks(listener, filter, endpoint, added);
            }
        }
    }

    private void triggerCallbacks(EndpointListener endpointListener, String filter, EndpointDescription endpoint, boolean added) {
        if (!LocalDiscovery.matchFilter(filter, endpoint)) {
            return;
        }
        if (added) {
            endpointListener.endpointAdded(endpoint, filter);
        } else {
            endpointListener.endpointRemoved(endpoint, filter);
        }
    }

    private void triggerCallbacks(Collection<String> filters, EndpointListener endpointListener) {
        for (String filter : filters) {
            for (EndpointDescription endpoint : this.endpointDescriptions.keySet()) {
                this.triggerCallbacks(endpointListener, filter, endpoint, true);
            }
        }
    }

    private static boolean matchFilter(String filter, EndpointDescription endpoint) {
        if (filter == null) {
            return false;
        }
        try {
            Filter f = FrameworkUtil.createFilter((String)filter);
            Hashtable dict = new Hashtable(endpoint.getProperties());
            return f.match(dict);
        }
        catch (Exception e) {
            return false;
        }
    }
}

