/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark;

import java.util.Date;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.spark.util.Util;

public class LoggingToAccumAdapter
implements KettleLoggingEventListener {
    private CollectionAccumulator<LogEntry> accumulator;
    private static LoggingToAccumAdapter instance = new LoggingToAccumAdapter();

    public static LoggingToAccumAdapter getInstance() {
        return instance;
    }

    private LoggingToAccumAdapter() {
    }

    public void eventAdded(KettleLoggingEvent kle) {
        if (this.accumulator == null) {
            return;
        }
        org.pentaho.di.core.logging.LogLevel logLevel = kle.getLevel();
        LogMessageInterface message = (LogMessageInterface)kle.getMessage();
        long timeStamp = kle.getTimeStamp();
        this.accumulator.add((Object)new LogEntry.LogEntryBuilder().withMessage(message.getMessage()).withLogLevel((LogLevel)Util.LEVEL_MAP.inverse().get((Object)logLevel)).withTimestamp(new Date(timeStamp)).build());
    }

    public void setAccumulator(CollectionAccumulator<LogEntry> accumulator) {
        this.accumulator = accumulator;
    }

    public CollectionAccumulator<LogEntry> getAccumulator() {
        return this.accumulator;
    }
}

