/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.accumulators;

import io.reactivex.subjects.Subject;
import java.util.List;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAccumSparkListener
extends SparkListener {
    private final CollectionAccumulator<LogEntry> accumulator;
    private final Subject<LogEntry> loggingSubject;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public LoggingAccumSparkListener(CollectionAccumulator<LogEntry> accumulator, Subject<LogEntry> loggingSubject) {
        this.accumulator = accumulator;
        this.loggingSubject = loggingSubject;
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        this.logger.debug("onStageCompleted called, will check accumulator");
        this.handle();
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.logger.debug("onApplicationEnd called, will check accumulator");
        this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle() {
        if (this.accumulator.value().size() > 0) {
            this.logger.debug("Logging Accumulator has values: " + this.accumulator.value().size());
            List list = this.accumulator.value();
            synchronized (list) {
                this.accumulator.value().forEach(arg_0 -> this.loggingSubject.onNext(arg_0));
            }
            this.accumulator.reset();
        }
    }
}

