/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.StageInfo;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.execution.FinalOperationCountEvent;
import org.pentaho.di.engine.spark.impl.execution.OperationEndedEvent;
import org.pentaho.di.engine.spark.impl.execution.OperationErrorEvent;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class OperationRDDEventListener
extends SparkListener {
    private static final String SUCCEEDED_STATUS = "succeeded";
    private final JavaSparkContext javaSparkContext;
    private final SparkOperation.Subscriber subscriber;
    private String operationName;
    private List<String> outputOps = new ArrayList<String>();
    private boolean initOperation = false;
    private boolean endOperation = false;
    private long linesIn = 0L;
    private long linesOut = 0L;
    private boolean linesOutWasSet = false;
    private String msgError = null;
    private Status stageStatus = Status.FINISHED;
    private Throwable throwable = null;
    private int stageCount = 0;
    private int nextStepsEnded = 0;
    private boolean readyToFinalize = false;
    private boolean finalized = false;

    public OperationRDDEventListener(JavaSparkContext javaSparkContext, SparkOperation.Subscriber subscriber, String operationName) {
        this.javaSparkContext = javaSparkContext;
        this.subscriber = subscriber;
        this.operationName = operationName;
        subscriber.getExpectedOutputs().stream().forEach(op -> this.outputOps.add(op.getId()));
        this.initOperation = subscriber.getInputs() == null ? true : subscriber.getInputs().isEmpty();
        this.endOperation = this.outputOps == null || this.outputOps.isEmpty();
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        this.stageCountInc();
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        this.stageCountDec();
        if (stageCompleted != null && stageCompleted.stageInfo() != null && stageCompleted.stageInfo().rddInfos() != null) {
            boolean isNextStepStage;
            boolean isThisOperationStage;
            boolean bl = isThisOperationStage = JavaConversions.seqAsJavaList((Seq)stageCompleted.stageInfo().rddInfos()).stream().filter(rddinfo -> this.operationName.equals(rddinfo.name())).count() > 0L;
            if (isThisOperationStage) {
                this.readStageInfoMetrics(stageCompleted.stageInfo(), false);
            }
            boolean bl2 = isNextStepStage = JavaConversions.seqAsJavaList((Seq)stageCompleted.stageInfo().rddInfos()).stream().filter(rddinfo -> this.outputOps.contains(rddinfo.name())).count() > 0L;
            if (this.initOperation && isNextStepStage) {
                this.readStageInfoMetrics(stageCompleted.stageInfo(), true);
            }
            if (isNextStepStage) {
                this.readNextStageMetrics(stageCompleted.stageInfo());
            }
        }
        if (this.stageCount == 0) {
            this.updateMetrics();
            this.updateSatus();
            if (this.readyToFinalize && !this.finalized) {
                this.finalizeOperation();
            }
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        if (event instanceof FinalOperationCountEvent) {
            this.finalOperationCountEvent((FinalOperationCountEvent)event);
        } else if (event instanceof OperationErrorEvent) {
            this.operationErrorEvent((OperationErrorEvent)event);
        } else if (event instanceof OperationEndedEvent) {
            this.operationEndedEvent((OperationEndedEvent)event);
        }
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.finalizeOperation();
    }

    private void finalOperationCountEvent(FinalOperationCountEvent event) {
        if (this.operationName.equals(event.getOperation())) {
            this.linesOut = event.getTotal() > 0L ? event.getTotal() : this.linesOut;
            this.updateMetrics();
            this.updateSatus();
            this.finalizeOperation();
            OperationEndedEvent.sendEvent(this.javaSparkContext, this.operationName);
        }
    }

    private void operationEndedEvent(OperationEndedEvent event) {
        if (!this.endOperation && this.outputOps.contains(event.getOperation())) {
            this.nextStepEndedInc();
            if (this.nextStepsEnded >= this.outputOps.size()) {
                this.readyToFinalize = true;
                if (this.stageCount <= 0) {
                    this.finalizeOperation();
                }
                OperationEndedEvent.sendEvent(this.javaSparkContext, this.operationName);
            }
        }
    }

    private void operationErrorEvent(OperationErrorEvent event) {
        if (this.operationName.equals(event.getOperation())) {
            this.throwable = event.getThrowable();
        }
        this.finalizeOperation();
    }

    private void readNextStageMetrics(StageInfo stageInfo) {
        if (!this.linesOutWasSet) {
            this.linesOut += stageInfo.taskMetrics().inputMetrics().recordsRead();
        }
    }

    private void readStageInfoMetrics(StageInfo stageInfo, boolean initOperation) {
        if (!initOperation) {
            this.linesIn = stageInfo.taskMetrics().inputMetrics().recordsRead();
        }
        if (stageInfo.taskMetrics().outputMetrics().recordsWritten() > 0L) {
            this.linesOut = !this.linesOutWasSet && this.linesOut > 0L ? 0L : this.linesOut;
            this.linesOut += stageInfo.taskMetrics().outputMetrics().recordsWritten();
            this.linesOutWasSet = true;
        }
        this.stageStatus = SUCCEEDED_STATUS.equals(stageInfo.getStatusString()) ? Status.FINISHED : Status.FAILED;
        this.msgError = stageInfo.failureReason().isEmpty() ? null : (String)stageInfo.failureReason().get();
    }

    private void updateMetrics() {
        this.subscriber.updateMetrics(metrics -> new Metrics(this.linesIn, this.linesOut, 0L, 0L));
    }

    private void updateSatus() {
        this.subscriber.updateStatus(this.stageStatus, this.msgError);
    }

    private void finalizeOperation() {
        this.finalized = true;
        if (this.throwable != null) {
            this.subscriber.finalize(this.throwable);
        } else {
            this.subscriber.finalize(this.msgError != null && !this.msgError.isEmpty() ? new Throwable(this.msgError) : null);
        }
    }

    private synchronized void stageCountInc() {
        ++this.stageCount;
    }

    private synchronized void stageCountDec() {
        if (this.stageCount > 0) {
            --this.stageCount;
        }
    }

    private synchronized void nextStepEndedInc() {
        ++this.nextStepsEnded;
    }
}

