/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowHandler;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;

public class GenericStepFlatMapFunction
extends TransSerializingBase
implements Serializable,
FlatMapFunction<Row, Row> {
    private static final long serialVersionUID = 6864926003187131863L;
    private Operation operation;
    protected transient StepDataInterface stepDataInterface;
    protected transient StepMetaInterface stepMetaInterface;
    protected transient RowMetaInterface rowMetaInterface;
    protected transient BaseStep step;
    private AtomicBoolean initialized = new AtomicBoolean(false);

    public GenericStepFlatMapFunction(TransMeta transMeta, String stepName, Operation operation) {
        super(transMeta, stepName);
        this.operation = operation;
        this.init(transMeta, stepName);
    }

    public GenericStepFlatMapFunction() {
    }

    @Override
    protected void init(TransMeta transMeta, String stepName) {
        super.init(transMeta, this.id);
        this.rowMetaInterface = Util.getRowMeta(transMeta, stepName);
        this.step = Util.getTypedStep(transMeta, stepName, BaseStep.class);
        this.step.setInputRowMeta(Util.getPrevStepFields(transMeta, stepName));
        this.stepMetaInterface = this.step.getStepMeta().getStepMetaInterface();
        this.stepDataInterface = this.step.getStepDataInterface();
        this.step.init(this.stepMetaInterface, this.stepDataInterface);
    }

    public List<Row> getRowListForStep() {
        try {
            final ArrayList output = new ArrayList();
            this.step.setRowHandler(new RowHandler(){

                public Object[] getRow() throws KettleException {
                    return null;
                }

                public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    output.add(row);
                }

                public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
                }
            });
            boolean bContinue = true;
            while (bContinue) {
                bContinue = this.step.processRow(this.stepMetaInterface, this.stepDataInterface);
            }
            return output.stream().map(objects -> new KettleRow(this.rowMetaInterface, (Object[])objects)).collect(Collectors.toList());
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<Row> call(Row row) throws Exception {
        this.logRow();
        try {
            final ArrayList<Object[]> input = new ArrayList<Object[]>();
            final ArrayList output = new ArrayList();
            input.add(row.getObjects());
            this.step.setRowHandler(new RowHandler(){

                public Object[] getRow() throws KettleException {
                    return input.size() == 0 ? null : (Object[])input.remove(0);
                }

                public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                    output.add(row);
                }

                public void putError(RowMetaInterface rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws KettleStepException {
                }
            });
            this.step.processRow(this.stepMetaInterface, this.stepDataInterface);
            return output.stream().map(objects -> new KettleRow(this.rowMetaInterface, (Object[])objects)).collect(Collectors.toList()).iterator();
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }
}

