/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.TransSerializingBase;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;

public class KettleFilterFunction
extends TransSerializingBase
implements FlatMapFunction<Row, Row> {
    private transient FilterRowsMeta filterMeta;
    private transient RowMetaInterface rowMetaInterface;
    private boolean truePath;

    public KettleFilterFunction(TransMeta transMeta, String id, boolean truePredicate) {
        super(transMeta, id);
        this.init(transMeta, id);
        this.truePath = truePredicate;
    }

    @Override
    public void init(TransMeta transMeta, String id) {
        super.init(transMeta, id);
        this.filterMeta = Util.getTypedStepMeta(transMeta.findStep(id), FilterRowsMeta.class);
        this.rowMetaInterface = Util.getRowMeta(transMeta, id);
    }

    public Iterator<Row> call(Row row) throws Exception {
        this.logRow();
        return ImmutableList.of((Object)row).stream().filter(this::evaluateCond).iterator();
    }

    public boolean evaluateCond(Row row) {
        return this.truePath == this.filterMeta.getCondition().evaluate(this.rowMetaInterface, row.getObjects());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
    }
}

