/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.spark.impl.functions.GenericStepFlatMapFunction;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupData;

public class StreamLookupFlatMapFunction
extends GenericStepFlatMapFunction
implements Serializable,
FlatMapFunction<Row, Row> {
    private static final long serialVersionUID = 3456027508745372158L;
    private transient BaseStep step;
    private Broadcast<List<Row>> infoStream;
    private String infoStreamName;

    public StreamLookupFlatMapFunction(TransMeta transMeta, String stepName, Operation operation, Broadcast<List<Row>> infoStream) {
        super(transMeta, stepName, operation);
        this.infoStream = infoStream;
        this.prepInfoStream();
    }

    @Override
    protected void init(TransMeta transMeta, String stepName) {
        super.init(transMeta, stepName);
        try {
            this.rowMetaInterface = transMeta.getStepFields(transMeta.findStep(stepName));
            this.step = Util.getTypedStep(transMeta, stepName, BaseStep.class);
            this.stepDataInterface = this.step.getStepDataInterface();
            this.stepMetaInterface = this.step.getStepMeta().getStepMetaInterface();
            this.step.getTrans().setRunning(true);
            this.step.init(this.stepMetaInterface, this.stepDataInterface);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepInfoStream() {
        this.infoStreamName = ((StreamInterface)this.stepMetaInterface.getStepIOMeta().getInfoStreams().get(0)).getStepMeta().getName();
        RowSet rowSetLookup = this.step.getTrans().rowsets.stream().filter(rowset -> this.infoStreamName.equals(rowset.getOriginStepName())).findFirst().get();
        try {
            this.injectInfoStreamValuesToRowSet(this.transMeta, rowSetLookup);
            if (((StreamLookupData)this.stepDataInterface).readLookupValues && !this.step.processRow(this.stepMetaInterface, this.stepDataInterface)) {
                throw new RuntimeException("Unable to read data from lookup-stream");
            }
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectInfoStreamValuesToRowSet(TransMeta transMeta, RowSet rowSetLookup) throws KettleException {
        RowMetaInterface outputRowMeta = Util.getRowMeta(transMeta, this.infoStreamName);
        ((List)this.infoStream.getValue()).forEach(row -> rowSetLookup.putRow(outputRowMeta, row.getObjects()));
        rowSetLookup.setDone();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        super.writeObjectDefault(oos);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        super.readObjectDefault(ois);
        this.prepInfoStream();
    }
}

