/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RegistrationManager<T> {
    private final Lock registrationLock = new ReentrantLock();
    private final List<RegStateWrapper> opqueue = new ArrayList<RegStateWrapper>();
    private volatile T m_serviceRegistration;

    RegistrationManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeRegistration(RegState desired, String[] services) {
        boolean bl;
        block46: {
            RegStateWrapper rsw;
            block43: {
                boolean bl2;
                block44: {
                    block38: {
                        boolean bl3;
                        block41: {
                            block37: {
                                boolean bl4;
                                block39: {
                                    rsw = null;
                                    this.registrationLock.lock();
                                    if (!this.opqueue.isEmpty()) break block37;
                                    if (desired == RegState.unregistered != (this.m_serviceRegistration == null)) break block38;
                                    this.log(4, "Already in desired state {0}", new Object[]{desired}, null);
                                    bl4 = false;
                                    Object var9_9 = null;
                                    this.registrationLock.unlock();
                                    if (rsw == null) break block39;
                                    try {
                                        if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                            this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                            this.reportTimeout();
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        try {
                                            if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                                this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                                this.reportTimeout();
                                            }
                                        }
                                        catch (InterruptedException e1) {
                                            this.log(1, "Interrupted twice waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                        }
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                return bl4;
                            }
                            if (this.opqueue.get(this.opqueue.size() - 1).getRegState() != desired) break block38;
                            this.log(4, "Duplicate request on other thread: registration change queue {0}", new Object[]{this.opqueue}, null);
                            rsw = this.opqueue.get(this.opqueue.size() - 1);
                            bl3 = false;
                            Object var9_10 = null;
                            this.registrationLock.unlock();
                            if (rsw == null) break block41;
                            try {
                                if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                    this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                    this.reportTimeout();
                                }
                            }
                            catch (InterruptedException e) {
                                try {
                                    if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                        this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                        this.reportTimeout();
                                    }
                                }
                                catch (InterruptedException e1) {
                                    this.log(1, "Interrupted twice waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                }
                                Thread.currentThread().interrupt();
                            }
                        }
                        return bl3;
                    }
                    rsw = new RegStateWrapper(desired);
                    this.opqueue.add(rsw);
                    if (this.opqueue.size() <= 1) break block43;
                    this.log(4, "Allowing other thread to process request: registration change queue {0}", new Object[]{this.opqueue}, null);
                    bl2 = true;
                    Object var9_11 = null;
                    this.registrationLock.unlock();
                    if (rsw == null) break block44;
                    try {
                        if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                            this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                            this.reportTimeout();
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                this.reportTimeout();
                            }
                        }
                        catch (InterruptedException e1) {
                            this.log(1, "Interrupted twice waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                return bl2;
            }
            try {
                do {
                    Object var7_25;
                    this.log(4, "registration change queue {0}", new Object[]{this.opqueue}, null);
                    RegStateWrapper next = this.opqueue.get(0);
                    T serviceRegistration = this.m_serviceRegistration;
                    if (next.getRegState() == RegState.unregistered) {
                        this.m_serviceRegistration = null;
                    }
                    this.registrationLock.unlock();
                    try {
                        if (next.getRegState() == RegState.registered) {
                            serviceRegistration = this.register(services);
                        } else if (serviceRegistration != null) {
                            this.unregister(serviceRegistration);
                        } else {
                            this.log(1, "Unexpected unregistration request with no registration present", new Object[0], new Exception("Stack trace"));
                        }
                        var7_25 = null;
                        this.registrationLock.lock();
                        this.opqueue.remove(0);
                    }
                    catch (Throwable throwable) {
                        var7_25 = null;
                        this.registrationLock.lock();
                        this.opqueue.remove(0);
                        if (next.getRegState() == RegState.registered) {
                            this.m_serviceRegistration = serviceRegistration;
                            this.postRegister(this.m_serviceRegistration);
                        }
                        next.getLatch().countDown();
                        throw throwable;
                    }
                    if (next.getRegState() == RegState.registered) {
                        this.m_serviceRegistration = serviceRegistration;
                        this.postRegister(this.m_serviceRegistration);
                    }
                    next.getLatch().countDown();
                } while (!this.opqueue.isEmpty());
                bl = true;
                Object var9_12 = null;
                this.registrationLock.unlock();
                if (rsw == null) break block46;
            }
            catch (Throwable throwable) {
                block48: {
                    Object var9_13 = null;
                    this.registrationLock.unlock();
                    if (rsw == null) break block48;
                    try {
                        if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                            this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                            this.reportTimeout();
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                                this.reportTimeout();
                            }
                        }
                        catch (InterruptedException e1) {
                            this.log(1, "Interrupted twice waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                throw throwable;
            }
            try {
                if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                    this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                    this.reportTimeout();
                }
            }
            catch (InterruptedException e) {
                try {
                    if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                        this.log(1, "Timeout waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                        this.reportTimeout();
                    }
                }
                catch (InterruptedException e1) {
                    this.log(1, "Interrupted twice waiting for reg change to complete {0}", new Object[]{rsw.getRegState()}, null);
                }
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    abstract T register(String[] var1);

    abstract void postRegister(T var1);

    abstract void unregister(T var1);

    abstract void log(int var1, String var2, Object[] var3, Throwable var4);

    abstract long getTimeout();

    abstract void reportTimeout();

    T getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    private static class RegStateWrapper {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final RegState regState;

        RegStateWrapper(RegState regState) {
            this.regState = regState;
        }

        public RegState getRegState() {
            return this.regState;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public int hashCode() {
            return this.regState.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof RegStateWrapper && this.regState == ((RegStateWrapper)other).getRegState();
        }

        public String toString() {
            return this.regState.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RegState {
        unregistered,
        registered;

    }
}

