/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.exporter;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.rsa.topologymanager.exporter.EndpointRepository;
import org.apache.aries.rsa.util.StringPlus;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointListenerNotifier
implements EndpointListener {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointListenerNotifier.class);
    private Map<EndpointListener, Set<Filter>> listeners;
    private EndpointRepository endpointRepo;

    public EndpointListenerNotifier(EndpointRepository endpointRepo) {
        this.endpointRepo = endpointRepo;
        this.listeners = new ConcurrentHashMap<EndpointListener, Set<Filter>>();
    }

    public static Set<Filter> getFiltersFromEndpointListenerScope(ServiceReference<EndpointListener> sref) {
        HashSet<Filter> filters = new HashSet<Filter>();
        List scopes = StringPlus.normalize((Object)sref.getProperty("endpoint.listener.scope"));
        for (String scope : scopes) {
            try {
                filters.add(FrameworkUtil.createFilter((String)scope));
            }
            catch (InvalidSyntaxException e) {
                LOG.error("invalid endpoint listener scope: {}", (Object)scope, (Object)e);
            }
        }
        return filters;
    }

    public void add(EndpointListener ep, Set<Filter> filters) {
        LOG.debug("new EndpointListener detected");
        this.listeners.put(ep, filters);
        for (EndpointDescription endpoint : this.endpointRepo.getAllEndpoints()) {
            this.notifyListener(NotifyType.ADDED, ep, filters, endpoint);
        }
    }

    public void remove(EndpointListener ep) {
        LOG.debug("EndpointListener modified");
        this.listeners.remove(ep);
    }

    public void endpointAdded(EndpointDescription endpoint, String matchedFilter) {
        this.notifyListeners(NotifyType.ADDED, endpoint);
    }

    public void endpointRemoved(EndpointDescription endpoint, String matchedFilter) {
        this.notifyListeners(NotifyType.REMOVED, endpoint);
    }

    private void notifyListeners(NotifyType type, EndpointDescription endpoint) {
        for (EndpointListener listener : this.listeners.keySet()) {
            this.notifyListener(type, listener, this.listeners.get(listener), endpoint);
        }
    }

    private void notifyListener(NotifyType type, EndpointListener listener, Set<Filter> filters, EndpointDescription endpoint) {
        LOG.debug("Endpoint {}", (Object)type);
        Set<Filter> matchingFilters = EndpointListenerNotifier.getMatchingFilters(filters, endpoint);
        for (Filter filter : matchingFilters) {
            if (type == NotifyType.ADDED) {
                listener.endpointAdded(endpoint, filter.toString());
                continue;
            }
            listener.endpointRemoved(endpoint, filter.toString());
        }
    }

    private static Set<Filter> getMatchingFilters(Set<Filter> filters, EndpointDescription endpoint) {
        HashSet<Filter> matchingFilters = new HashSet<Filter>();
        Hashtable dict = new Hashtable(endpoint.getProperties());
        for (Filter filter : filters) {
            if (filter.match(dict)) {
                LOG.debug("Filter {} matches endpoint {}", (Object)filter, dict);
                matchingFilters.add(filter);
                continue;
            }
            LOG.trace("Filter {} does not match endpoint {}", (Object)filter, dict);
        }
        return matchingFilters;
    }

    private static enum NotifyType {
        ADDED,
        REMOVED;

    }
}

