/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer;

import java.util.Collection;
import org.apache.aries.rsa.topologymanager.importer.FilterHelper;
import org.apache.aries.rsa.topologymanager.importer.ServiceInterestListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSFindHook
implements FindHook {
    private static final Logger LOG = LoggerFactory.getLogger(RSFindHook.class);
    private BundleContext bctx;
    private String frameworkUUID;
    private ServiceInterestListener serviceInterestListener;

    public RSFindHook(BundleContext bc, ServiceInterestListener serviceInterestListener) {
        this.bctx = bc;
        this.frameworkUUID = this.bctx.getProperty("org.osgi.framework.uuid");
        this.serviceInterestListener = serviceInterestListener;
    }

    public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
        String className;
        if (context.equals(this.bctx)) {
            LOG.debug("ListenerHookImpl: skipping request from myself");
            return;
        }
        String fullFilter = FilterHelper.getFullFilter(name, filter);
        if (fullFilter == null) {
            LOG.debug("skipping empty filter");
            return;
        }
        String string = className = name != null ? name : FilterHelper.getObjectClass(fullFilter);
        if (FilterHelper.isClassExcluded(className)) {
            LOG.debug("Skipping import request for excluded class [{}]", (Object)className);
            return;
        }
        String exFilter = this.extendFilter(fullFilter);
        this.serviceInterestListener.addServiceInterest(exFilter);
    }

    String extendFilter(String filter) {
        return "(&" + filter + "(!(" + "endpoint.framework.uuid" + "=" + this.frameworkUUID + ")))";
    }
}

