/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.impl;

import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.pentaho.osgi.api.BeanFactory;
import org.pentaho.osgi.api.BeanFactoryLocator;
import org.pentaho.osgi.impl.BeanFactoryBlueprintImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanFactoryLocatorImpl
implements BeanFactoryLocator {
    private static final String CONTAINER_KEY = "org.osgi.service.blueprint.container.BlueprintContainer";
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public BeanFactory getBeanFactory(Bundle bundle) {
        try {
            BundleContext bundleContext = bundle.getBundleContext();
            Collection serviceReferences = bundleContext.getServiceReferences(BlueprintContainer.class, "(osgi.blueprint.container.symbolicname=" + bundle.getSymbolicName() + ")");
            if (serviceReferences.size() == 0) {
                return null;
            }
            ServiceReference reference = (ServiceReference)serviceReferences.iterator().next();
            BlueprintContainer service = (BlueprintContainer)bundleContext.getService(reference);
            return new BeanFactoryBlueprintImpl(service);
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Error finding blueprint container", (Throwable)e);
            return null;
        }
    }

    public BeanFactory getBeanFactory(Object serviceObject) {
        if (serviceObject instanceof BlueprintContainer) {
            return new BeanFactoryBlueprintImpl((BlueprintContainer)serviceObject);
        }
        return null;
    }
}

