/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import org.apache.aries.rsa.provider.fastbin.api.AsyncCallback;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.AbstractInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.ResponseFuture;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;

public class AsyncPromiseInvocationStrategy
extends AbstractInvocationStrategy {
    @Override
    protected void doService(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        AbstractInvocationStrategy.AsyncServiceResponse helper = new AbstractInvocationStrategy.AsyncServiceResponse(loader, method, responseStream, onComplete, serializationStrategy);
        try {
            Class<?>[] types = method.getParameterTypes();
            Object[] args = new Object[types.length];
            serializationStrategy.decodeRequest(loader, types, requestStream, args);
            Promise promise = (Promise)method.invoke(target, args);
            promise.onResolve(() -> {
                try {
                    helper.send(promise.getFailure(), promise.getFailure() == null ? promise.getValue() : null);
                }
                catch (Exception e) {
                    helper.send(e, null);
                }
            });
        }
        catch (Throwable t) {
            helper.send(t, null);
        }
    }

    @Override
    protected ResponseFuture createResponse(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args) throws Exception {
        return new AsyncResponseFuture(loader, method, serializationStrategy, Dispatch.getCurrentQueue());
    }

    @Override
    protected Class getResultType(Method method) {
        try {
            Type type = method.getGenericReturnType();
            ParameterizedType t = (ParameterizedType)type;
            return (Class)t.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return super.getResultType(method);
        }
    }

    private class AsyncResponseFuture
    implements ResponseFuture,
    AsyncCallback {
        private final ClassLoader loader;
        private final Method method;
        private final SerializationStrategy serializationStrategy;
        private final DispatchQueue queue;
        private Deferred<Object> deferred;

        public AsyncResponseFuture(ClassLoader loader, Method method, SerializationStrategy serializationStrategy, DispatchQueue queue) {
            this.loader = loader;
            this.method = method;
            this.serializationStrategy = serializationStrategy;
            this.queue = queue;
            this.deferred = new Deferred();
        }

        @Override
        public void set(final DataByteArrayInputStream source) {
            if (this.queue != null) {
                this.queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        AsyncResponseFuture.this.decodeIt(source);
                    }
                });
            } else {
                this.decodeIt(source);
            }
        }

        private void decodeIt(DataByteArrayInputStream source) {
            try {
                this.serializationStrategy.decodeResponse(this.loader, AsyncPromiseInvocationStrategy.this.getResultType(this.method), source, this);
            }
            catch (Throwable e) {
                this.onFailure(e);
            }
        }

        @Override
        public void fail(Throwable throwable) {
            this.onFailure(throwable);
        }

        public void onSuccess(Object result) {
            this.deferred.resolve(result);
        }

        @Override
        public void onFailure(Throwable failure) {
            this.deferred.fail(failure);
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws Exception {
            return this.deferred.getPromise();
        }
    }
}

