/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.aries.rsa.provider.fastbin.api.Dispatched;
import org.apache.aries.rsa.provider.fastbin.api.ObjectSerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.api.Serialization;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.io.ClientInvoker;
import org.apache.aries.rsa.provider.fastbin.io.ProtocolCodec;
import org.apache.aries.rsa.provider.fastbin.io.Transport;
import org.apache.aries.rsa.provider.fastbin.tcp.InvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.InvocationType;
import org.apache.aries.rsa.provider.fastbin.tcp.LengthPrefixedCodec;
import org.apache.aries.rsa.provider.fastbin.tcp.ResponseFuture;
import org.apache.aries.rsa.provider.fastbin.tcp.TcpTransportFactory;
import org.apache.aries.rsa.provider.fastbin.tcp.TransportPool;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferEditor;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.osgi.framework.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientInvokerImpl
implements ClientInvoker,
Dispatched {
    public static final long DEFAULT_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    protected static final Logger LOGGER = LoggerFactory.getLogger(ClientInvokerImpl.class);
    private static final Map<Class, String> CLASS_TO_PRIMITIVE = new HashMap<Class, String>(8, 1.0f);
    protected final AtomicLong correlationGenerator = new AtomicLong();
    protected final DispatchQueue queue;
    protected final Map<String, TransportPool> transports = new HashMap<String, TransportPool>();
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected final Map<Long, ResponseFuture> requests = new HashMap<Long, ResponseFuture>();
    protected final long timeout;
    protected final Map<String, SerializationStrategy> serializationStrategies;
    static final WeakHashMap<Method, MethodData> method_cache;

    public ClientInvokerImpl(DispatchQueue queue, Map<String, SerializationStrategy> serializationStrategies) {
        this(queue, DEFAULT_TIMEOUT, serializationStrategies);
    }

    public ClientInvokerImpl(DispatchQueue queue, long timeout, Map<String, SerializationStrategy> serializationStrategies) {
        this.queue = queue;
        this.timeout = timeout;
        this.serializationStrategies = serializationStrategies;
    }

    @Override
    public DispatchQueue queue() {
        return this.queue;
    }

    @Override
    public void start() throws Exception {
        this.start(null);
    }

    @Override
    public void start(Runnable onComplete) throws Exception {
        this.running.set(true);
        if (onComplete != null) {
            onComplete.run();
        }
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Runnable onComplete) {
        if (this.running.compareAndSet(true, false)) {
            this.queue().execute(new Runnable(){

                @Override
                public void run() {
                    final AtomicInteger latch = new AtomicInteger(ClientInvokerImpl.this.transports.size());
                    Runnable countDown = new Runnable(){

                        @Override
                        public void run() {
                            if (latch.decrementAndGet() == 0 && onComplete != null) {
                                onComplete.run();
                            }
                        }
                    };
                    for (TransportPool pool : ClientInvokerImpl.this.transports.values()) {
                        pool.stop(countDown);
                    }
                }
            });
        } else if (onComplete != null) {
            onComplete.run();
        }
    }

    @Override
    public InvocationHandler getProxy(String address, String service, ClassLoader classLoader) {
        return new ProxyInvocationHandler(address, service, classLoader);
    }

    protected void onCommand(TransportPool pool, Object data) {
        try {
            DataByteArrayInputStream bais = new DataByteArrayInputStream((Buffer)data);
            bais.readInt();
            long correlation = bais.readVarLong();
            pool.onDone(correlation);
            ResponseFuture response = this.requests.remove(correlation);
            if (response != null) {
                response.set(bais);
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while reading response", (Throwable)e);
        }
    }

    protected void onFailure(Object id, Throwable throwable) {
        ResponseFuture response = this.requests.remove(id);
        if (response != null) {
            response.fail(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodData getMethodData(Method method) throws IOException {
        MethodData rc = null;
        WeakHashMap<Method, MethodData> weakHashMap = method_cache;
        synchronized (weakHashMap) {
            rc = method_cache.get(method);
        }
        if (rc == null) {
            SerializationStrategy serializationStrategy;
            StringBuilder sb = new StringBuilder();
            sb.append(method.getName());
            sb.append(",");
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.encodeClassName(types[i]));
            }
            Buffer signature = new UTF8Buffer(sb.toString()).buffer();
            Serialization annotation = method.getAnnotation(Serialization.class);
            if (annotation != null) {
                serializationStrategy = this.serializationStrategies.get(annotation.value());
                if (serializationStrategy == null) {
                    throw new RuntimeException("Could not find the serialization strategy named: " + annotation.value());
                }
            } else {
                serializationStrategy = ObjectSerializationStrategy.INSTANCE;
            }
            InvocationStrategy strategy = InvocationType.forMethod(method);
            rc = new MethodData(strategy, serializationStrategy, signature);
            WeakHashMap<Method, MethodData> weakHashMap2 = method_cache;
            synchronized (weakHashMap2) {
                method_cache.put(method, rc);
            }
        }
        return rc;
    }

    String encodeClassName(Class<?> type) {
        if (type.getComponentType() != null) {
            return "[" + this.encodeClassName(type.getComponentType());
        }
        if (type.isPrimitive()) {
            return CLASS_TO_PRIMITIVE.get(type);
        }
        return "L" + type.getName();
    }

    protected Object request(ProxyInvocationHandler handler, final String address, UTF8Buffer service, ClassLoader classLoader, Method method, Object[] args) throws Exception {
        if (!this.running.get()) {
            throw new IllegalStateException("DOSGi Client stopped");
        }
        final long correlation = this.correlationGenerator.incrementAndGet();
        DataByteArrayOutputStream baos = new DataByteArrayOutputStream((int)((double)handler.lastRequestSize * 1.1));
        baos.writeInt(0);
        baos.writeVarLong(correlation);
        this.writeBuffer(baos, (Buffer)service);
        MethodData methodData = this.getMethodData(method);
        this.writeBuffer(baos, methodData.signature);
        final ResponseFuture future = methodData.invocationStrategy.request(methodData.serializationStrategy, classLoader, method, args, baos);
        final Buffer command = baos.toBuffer();
        BufferEditor editor = command.buffer().bigEndianEditor();
        editor.writeInt(command.length);
        handler.lastRequestSize = command.length;
        this.queue().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TransportPool pool = ClientInvokerImpl.this.transports.get(address);
                    if (pool == null) {
                        pool = new InvokerTransportPool(address, ClientInvokerImpl.this.queue());
                        ClientInvokerImpl.this.transports.put(address, pool);
                        pool.start();
                    }
                    ClientInvokerImpl.this.requests.put(correlation, future);
                    pool.offer(command, correlation);
                }
                catch (Exception e) {
                    LOGGER.info("Error while sending request", (Throwable)e);
                    future.fail(e);
                }
            }
        });
        return future.get(this.timeout, TimeUnit.MILLISECONDS);
    }

    private void writeBuffer(DataByteArrayOutputStream baos, Buffer value) throws IOException {
        baos.writeVarInt(value.length);
        baos.write(value);
    }

    static {
        CLASS_TO_PRIMITIVE.put(Boolean.TYPE, "Z");
        CLASS_TO_PRIMITIVE.put(Byte.TYPE, "B");
        CLASS_TO_PRIMITIVE.put(Character.TYPE, "C");
        CLASS_TO_PRIMITIVE.put(Short.TYPE, "S");
        CLASS_TO_PRIMITIVE.put(Integer.TYPE, "I");
        CLASS_TO_PRIMITIVE.put(Long.TYPE, "J");
        CLASS_TO_PRIMITIVE.put(Float.TYPE, "F");
        CLASS_TO_PRIMITIVE.put(Double.TYPE, "D");
        method_cache = new WeakHashMap();
    }

    protected class InvokerTransportPool
    extends TransportPool {
        public InvokerTransportPool(String uri, DispatchQueue queue) {
            super(uri, queue, 2, ClientInvokerImpl.this.timeout << 1);
        }

        @Override
        protected Transport createTransport(String uri) throws Exception {
            return new TcpTransportFactory().connect(uri);
        }

        @Override
        protected ProtocolCodec createCodec() {
            return new LengthPrefixedCodec();
        }

        @Override
        protected void onCommand(Object command) {
            ClientInvokerImpl.this.onCommand(this, command);
        }

        @Override
        protected void onFailure(Object id, Throwable throwable) {
            ClientInvokerImpl.this.onFailure(id, throwable);
        }
    }

    protected class ProxyInvocationHandler
    implements InvocationHandler {
        final String address;
        final UTF8Buffer service;
        final ClassLoader classLoader;
        int lastRequestSize = 250;

        public ProxyInvocationHandler(String address, String service, ClassLoader classLoader) {
            this.address = address;
            this.service = new UTF8Buffer(service);
            this.classLoader = classLoader;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return ClientInvokerImpl.this.request(this, this.address, this.service, this.classLoader, method, args);
            }
            catch (Throwable e) {
                Class<?>[] exceptionTypes;
                if (e instanceof ExecutionException) {
                    ExecutionException executionException = (ExecutionException)e;
                    e = executionException.getCause();
                }
                if (e instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)e;
                    throw runtimeException;
                }
                for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
                    if (!exceptionType.isAssignableFrom(e.getClass())) continue;
                    throw e;
                }
                throw new ServiceException(e.getMessage(), e);
            }
        }
    }

    static class MethodData {
        private final SerializationStrategy serializationStrategy;
        final Buffer signature;
        final InvocationStrategy invocationStrategy;

        MethodData(InvocationStrategy invocationStrategy, SerializationStrategy serializationStrategy, Buffer signature) {
            this.invocationStrategy = invocationStrategy;
            this.serializationStrategy = serializationStrategy;
            this.signature = signature;
        }
    }
}

