/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.search.spans.SpanWeight;

public abstract class SpanQuery
extends Query {
    public abstract String getField();

    @Override
    public abstract SpanWeight createWeight(IndexSearcher var1, boolean var2) throws IOException;

    protected static Map<Term, TermContext> getTermContexts(SpanWeight ... weights) {
        TreeMap<Term, TermContext> terms = new TreeMap<Term, TermContext>();
        for (SpanWeight w : weights) {
            w.extractTermContexts(terms);
        }
        return terms;
    }

    protected static Map<Term, TermContext> getTermContexts(Collection<SpanWeight> weights) {
        TreeMap<Term, TermContext> terms = new TreeMap<Term, TermContext>();
        for (SpanWeight w : weights) {
            w.extractTermContexts(terms);
        }
        return terms;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (super.getBoost() != 1.0f) {
            SpanQuery rewritten = (SpanQuery)this.clone();
            rewritten.setBoost(1.0f);
            return new SpanBoostQuery(rewritten, super.getBoost());
        }
        return this;
    }
}

