/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.kerberos;

import java.security.Principal;
import java.security.PrivilegedAction;
import org.apache.wss4j.common.kerberos.KerberosServiceContext;
import org.apache.wss4j.common.kerberos.KerberosServiceExceptionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosServiceAction
implements PrivilegedAction<Principal> {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosServiceAction.class);
    private byte[] ticket;
    private String serviceName;
    private boolean isUsernameServiceNameForm;

    public KerberosServiceAction(byte[] ticket, String serviceName) {
        this(ticket, serviceName, false);
    }

    public KerberosServiceAction(byte[] ticket, String serviceName, boolean isUsernameServiceNameForm) {
        this.ticket = ticket;
        this.serviceName = serviceName;
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    @Override
    public Principal run() {
        try {
            KerberosServiceExceptionAction action = new KerberosServiceExceptionAction(this.ticket, this.serviceName, this.isUsernameServiceNameForm, false);
            KerberosServiceContext krbServiceCtx = action.run();
            return krbServiceCtx.getPrincipal();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error in validating a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }
}

