/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.engine;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.pentaho.platform.api.engine.IServerStatusChangeListener;
import org.pentaho.platform.api.engine.IServerStatusProvider;

public class ServerStatusProvider
implements IServerStatusProvider {
    private String[] messages;
    private IServerStatusProvider.ServerStatus serverStatus = IServerStatusProvider.ServerStatus.DOWN;
    private final List<IServerStatusChangeListener> listeners = new CopyOnWriteArrayList<IServerStatusChangeListener>();

    @Override
    public IServerStatusProvider.ServerStatus getStatus() {
        return this.serverStatus;
    }

    @Override
    public String[] getStatusMessages() {
        return this.messages;
    }

    @Override
    public void setStatus(IServerStatusProvider.ServerStatus serverStatus) {
        if (this.serverStatus != serverStatus) {
            this.serverStatus = serverStatus;
            this.fireOnChange();
        }
    }

    @Override
    public void registerServerStatusChangeListener(IServerStatusChangeListener serverStatusChangeListener) {
        this.listeners.add(serverStatusChangeListener);
    }

    @Override
    public void removeServerStatusChangeListener(IServerStatusChangeListener serverStatusChangeListener) {
        this.listeners.remove(serverStatusChangeListener);
    }

    @Override
    public void setStatusMessages(String[] messages) {
        if (this.messages != messages) {
            this.messages = messages;
            this.fireOnChange();
        }
    }

    private void fireOnChange() {
        for (IServerStatusChangeListener listener : this.listeners) {
            listener.onStatusChange();
        }
    }
}

