/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;

public class RepositoryFileAcl
implements Serializable {
    private static final long serialVersionUID = 6661340152568187033L;
    private final List<RepositoryFileAce> aces;
    private final Serializable id;
    private final RepositoryFileSid owner;
    private final boolean entriesInheriting;

    public RepositoryFileAcl(Serializable id, RepositoryFileSid owner, boolean entriesInheriting, List<RepositoryFileAce> aces) {
        this.notNull(owner);
        this.notNull(aces);
        this.id = id;
        this.owner = owner;
        this.entriesInheriting = entriesInheriting;
        this.aces = new ArrayList<RepositoryFileAce>(aces);
    }

    private void notNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public List<RepositoryFileAce> getAces() {
        return Collections.unmodifiableList(this.aces);
    }

    public Serializable getId() {
        return this.id;
    }

    public RepositoryFileSid getOwner() {
        return this.owner;
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aces == null ? 0 : this.aces.hashCode());
        result = 31 * result + (this.entriesInheriting ? 1231 : 1237);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFileAcl other = (RepositoryFileAcl)obj;
        if (this.aces == null ? other.aces != null : !this.aces.equals(other.aces)) {
            return false;
        }
        if (this.entriesInheriting != other.entriesInheriting) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    public String toString() {
        return "RepositoryFileAcl [id=" + this.id + ", owner=" + this.owner + ", entriesInheriting=" + this.entriesInheriting + ", aces=" + this.aces + "]";
    }

    public static class Builder {
        private List<RepositoryFileAce> aces = new ArrayList<RepositoryFileAce>();
        private Serializable id;
        private RepositoryFileSid owner;
        private boolean entriesInheriting = true;

        public Builder(String owner) {
            this(new RepositoryFileSid(owner));
        }

        public Builder(RepositoryFileSid owner) {
            this((Serializable)null, owner);
        }

        public Builder(Serializable id, RepositoryFileSid owner) {
            this.id = id;
            this.owner = owner;
        }

        public Builder(String name, RepositoryFileSid.Type type) {
            this(null, new RepositoryFileSid(name, type));
        }

        public Builder(Serializable id, String name, RepositoryFileSid.Type type) {
            this(id, new RepositoryFileSid(name, type));
        }

        public Builder(RepositoryFileAcl other) {
            this(other.id, other.owner);
            this.entriesInheriting(other.entriesInheriting);
            for (RepositoryFileAce ace : other.aces) {
                this.ace(ace);
            }
        }

        public RepositoryFileAcl build() {
            return new RepositoryFileAcl(this.id, this.owner, this.entriesInheriting, this.aces);
        }

        public Builder entriesInheriting(boolean entriesInheriting1) {
            this.entriesInheriting = entriesInheriting1;
            return this;
        }

        public Builder id(Serializable id1) {
            this.id = id1;
            return this;
        }

        public Builder owner(RepositoryFileSid owner1) {
            this.owner = owner1;
            return this;
        }

        public Builder ace(RepositoryFileAce ace1) {
            this.entriesInheriting(false);
            this.aces.add(ace1);
            return this;
        }

        public Builder ace(RepositoryFileSid recipient, RepositoryFilePermission first, RepositoryFilePermission ... rest) {
            return this.ace(new RepositoryFileAce(recipient, EnumSet.of(first, rest)));
        }

        public Builder ace(RepositoryFileSid recipient, EnumSet<RepositoryFilePermission> permissions) {
            return this.ace(new RepositoryFileAce(recipient, permissions));
        }

        public Builder ace(String name, RepositoryFileSid.Type type, RepositoryFilePermission first, RepositoryFilePermission ... rest) {
            return this.ace(new RepositoryFileAce(new RepositoryFileSid(name, type), EnumSet.of(first, rest)));
        }

        public Builder ace(String name, RepositoryFileSid.Type type, EnumSet<RepositoryFilePermission> permissions) {
            return this.ace(new RepositoryFileAce(new RepositoryFileSid(name, type), permissions));
        }

        public Builder aces(List<RepositoryFileAce> aces1) {
            this.clearAces();
            this.entriesInheriting(false);
            this.aces.addAll(aces1);
            return this;
        }

        public Builder clearAces() {
            this.aces.clear();
            return this;
        }
    }
}

