/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;

public class RepositoryFileTree
implements Comparable<RepositoryFileTree>,
Serializable {
    private static final long serialVersionUID = 6282939978216638770L;
    private final RepositoryFile file;
    private final List<RepositoryFileTree> children;
    private Boolean versioningEnabled;
    private Boolean versionCommentEnabled;

    public RepositoryFileTree(RepositoryFile file, List<RepositoryFileTree> children) {
        this.notNull(file);
        this.file = file;
        this.children = children != null ? new ArrayList<RepositoryFileTree>(children) : null;
    }

    private void notNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    public RepositoryFile getFile() {
        return this.file;
    }

    public List<RepositoryFileTree> getChildren() {
        return this.children != null ? Collections.unmodifiableList(this.children) : null;
    }

    @Override
    public int compareTo(RepositoryFileTree other) {
        return this.file.compareTo(other.file);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFileTree other = (RepositoryFileTree)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }

    public String toString() {
        return this.toString(0);
    }

    protected String toString(int depth) {
        String SPACER = "  ";
        String NL = "\n";
        String SLASH = "/";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
        buf.append(this.file.getName());
        if (this.file.isFolder()) {
            buf.append("/");
        }
        buf.append("\n");
        if (this.children != null) {
            for (RepositoryFileTree subtree : this.children) {
                buf.append(subtree.toString(depth + 1));
            }
        }
        return buf.toString();
    }

    public Boolean getVersioningEnabled() {
        return this.versioningEnabled;
    }

    public void setVersioningEnabled(Boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    public Boolean getVersionCommentEnabled() {
        return this.versionCommentEnabled;
    }

    public void setVersionCommentEnabled(Boolean versionCommentEnabled) {
        this.versionCommentEnabled = versionCommentEnabled;
    }

    public static class Builder {
        private List<Builder> children;
        private RepositoryFile file;

        public Builder(RepositoryFile file, List<Builder> children) {
            this.file = file;
            this.children = children;
        }

        public Builder(RepositoryFile file) {
            this(file, new ArrayList<Builder>());
        }

        public Builder(RepositoryFileTree other) {
            this(other.file, Builder.toBuilderChildren(other.children));
        }

        public RepositoryFileTree build() {
            return new RepositoryFileTree(this.file, Builder.toTreeChildren(this.children));
        }

        public Builder child(Builder child) {
            this.children.add(child);
            return this;
        }

        private static List<RepositoryFileTree> toTreeChildren(List<Builder> children) {
            if (null == children) {
                return null;
            }
            ArrayList<RepositoryFileTree> converted = new ArrayList<RepositoryFileTree>(children.size());
            for (Builder child : children) {
                converted.add(child.build());
            }
            return converted;
        }

        private static List<Builder> toBuilderChildren(List<RepositoryFileTree> children) {
            if (null == children) {
                return null;
            }
            ArrayList<Builder> converted = new ArrayList<Builder>(children.size());
            for (RepositoryFileTree child : children) {
                converted.add(new Builder(child));
            }
            return converted;
        }

        public List<Builder> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public RepositoryFile getFile() {
            return this.file;
        }
    }
}

