/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.daemon.app.service;

import java.io.File;
import java.util.Map;
import org.pentaho.pdi.engine.daemon.app.service.DaemonConfiguration;

public class DaemonConfigurationImpl
implements DaemonConfiguration {
    private static final String INSTALLER_FILENAME = "daemon-spark-installer.jar";
    private static final String INSTALLER_MAIN = "org.pentaho.daemon.spark.installer.SparkInstallerMain";
    private static final String SPARK_FILENAME = "pdi-spark-driver.jar";
    private static final String SPARK_MAIN = "org.pentaho.pdi.spark.driver.SparkMain";
    private Map<String, String> properties;

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public String getHadoopConfDir() {
        return this.properties.get("hadoopConfDir");
    }

    @Override
    public String getSparkHome() {
        return this.properties.get("sparkHome");
    }

    @Override
    public String getHadoopUser() {
        return this.properties.get("hadoopUser");
    }

    @Override
    public String getSparkAppInstaller() {
        File karafHome = new File(System.getProperty("karaf.home"));
        File file = new File(karafHome, INSTALLER_FILENAME);
        return file.getAbsolutePath();
    }

    @Override
    public String getSparkApp() {
        return this.properties.get("sparkApp");
    }

    @Override
    public String getSparkAppInstallerClass() {
        return INSTALLER_MAIN;
    }

    @Override
    public String getSparkAppClass() {
        return SPARK_MAIN;
    }

    @Override
    public String getSparkMaster() {
        return this.properties.getOrDefault("sparkMaster", "local");
    }

    @Override
    public String getSparkDeployMode() {
        return this.properties.getOrDefault("sparkDeployMode", "client");
    }

    @Override
    public int getDriverDebugPort() {
        return Integer.valueOf(this.properties.getOrDefault("driverDebugPort", "-1"));
    }

    @Override
    public int getExecutorDebugPort() {
        return Integer.valueOf(this.properties.getOrDefault("executorDebugPort", "-1"));
    }

    @Override
    public boolean suspendDebug() {
        return Boolean.valueOf(this.properties.getOrDefault("suspendDebug", "false"));
    }

    @Override
    public String getSparkDriverExtraJavaOptions() {
        return this.properties.getOrDefault("sparkDriverExtraJavaOptions", "");
    }

    @Override
    public String getSparkExecutorExtraJavaOptions() {
        return this.properties.getOrDefault("sparkExecutorExtraJavaOptions", "");
    }

    @Override
    public String getSparkDriverMemory() {
        return this.properties.getOrDefault("sparkDriverMemory", "4g");
    }

    @Override
    public String getSparkExecutorMemory() {
        return this.properties.getOrDefault("sparkExecutorMemory", "1g");
    }

    @Override
    public String getAssemblyZip() {
        return this.properties.get("assemblyZip");
    }

    @Override
    public String getKerberosPrincipal() {
        return this.properties.get("kerberosPrincipal");
    }

    @Override
    public String getKeytabName() {
        return this.properties.get("keytabName");
    }

    @Override
    public boolean disableProxyUser() {
        return Boolean.valueOf(this.properties.getOrDefault("disableProxyUser", "false"));
    }

    @Override
    public String getDaemonHome() {
        return System.getProperty("karaf.base").replace("\\", "/");
    }

    @Override
    public boolean getOverwriteConfig() {
        return Boolean.valueOf(this.properties.getOrDefault("overwriteConfig", "true"));
    }
}

