/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.daemon.app.service;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.pentaho.pdi.engine.daemon.app.api.DaemonException;
import org.pentaho.pdi.engine.daemon.app.api.SparkConstants;
import org.pentaho.pdi.engine.daemon.app.service.DaemonConfiguration;
import org.pentaho.pdi.engine.daemon.app.service.HdfsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsServiceImpl
implements HdfsService {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsService.class);
    private final DaemonConfiguration config;

    public HdfsServiceImpl(DaemonConfiguration config) {
        LOG.info("HDFS Service Initialized");
        LOG.info(" - config:     {}", (Object)config);
        this.config = config;
    }

    @PostConstruct
    public void init() {
        LOG.info("init()");
    }

    @PreDestroy
    public void destroy() {
        LOG.info("destroy()");
    }

    @Override
    public void copyFromLocalFile(String sourceZip, String destinationFolder) {
        this.launch("copyFromLocalFile", sourceZip, destinationFolder);
    }

    @Override
    public void delete(String folder) {
        this.launch("delete", folder);
    }

    private void launch(String ... args) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put(SparkConstants.SPARK_HOME, this.config.getSparkHome());
            env.put(SparkConstants.HADOOP_CONF_DIR, this.config.getHadoopConfDir());
            String hadoopUser = this.config.getHadoopUser();
            if (!hadoopUser.isEmpty()) {
                env.put(SparkConstants.HADOOP_USER_NAME, hadoopUser);
            }
            File appResource = new File(this.config.getSparkAppInstaller());
            SparkLauncher sparkLauncher = new SparkLauncher(env);
            sparkLauncher.setMaster("local");
            sparkLauncher.setAppResource(appResource.getPath());
            sparkLauncher.setMainClass(this.config.getSparkAppInstallerClass());
            sparkLauncher.addAppArgs(args);
            SparkAppHandle sparkAppHandle = sparkLauncher.startApplication(new SparkAppHandle.Listener[0]);
            final CompletableFuture future = new CompletableFuture();
            sparkAppHandle.addListener(new SparkAppHandle.Listener(){

                public void stateChanged(SparkAppHandle sparkAppHandle) {
                    if (sparkAppHandle.getState().isFinal()) {
                        LOG.debug("State Changed: " + sparkAppHandle.getState().name());
                        future.complete(true);
                    }
                }

                public void infoChanged(SparkAppHandle sparkAppHandle) {
                }
            });
            future.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new DaemonException("Error Launching spark application", e);
        }
    }
}

